/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class ImageUtils {
    public static final PaletteData RGB24 = new PaletteData(255, 65280, 0xFF0000);

    public static ImageData convertPaletteToRGB24(ImageData data) {
        return ImageUtils.convertPalette(data, RGB24, 24);
    }

    public static ImageData convertPalette(ImageData data, PaletteData newPalette, int newDepth) {
        if (ImageUtils.paletteDataEquals(data.palette, newPalette)) {
            return data;
        }
        ImageData result = new ImageData(data.width, data.height, newDepth, newPalette);
        boolean hasAlpha = data.alphaData != null;
        int width = data.width;
        int height = data.height;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                RGB rgb = data.palette.getRGB(data.getPixel(x, y));
                result.setPixel(x, y, result.palette.getPixel(rgb));
                if (hasAlpha) {
                    int alpha = data.getAlpha(x, y);
                    result.setAlpha(x, y, alpha);
                }
                ++x;
            }
            ++y;
        }
        return result;
    }

    public static boolean paletteDataEquals(PaletteData p1, PaletteData p2) {
        if (p1.isDirect != p2.isDirect) {
            return false;
        }
        if (!p1.isDirect) {
            RGB[] rgb1 = p1.colors;
            RGB[] rgb2 = p2.colors;
            if (rgb1.length != rgb2.length) {
                return false;
            }
            int i = 0;
            while (i < rgb1.length) {
                if (rgb1[i].blue != rgb2[i].blue || rgb1[i].green != rgb2[i].green || rgb1[i].red != rgb2[i].red) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (p1.blueMask != p2.blueMask) {
            return false;
        }
        if (p1.blueShift != p2.blueShift) {
            return false;
        }
        if (p1.greenMask != p2.greenShift) {
            return false;
        }
        if (p1.greenMask != p2.greenMask) {
            return false;
        }
        if (p1.redMask != p2.redMask) {
            return false;
        }
        return p1.redShift == p2.redShift;
    }

    public static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            if (data.alphaData != null && data.depth == 24) {
                colorModel = new DirectColorModel(data.depth + 8, palette.redMask, palette.greenMask, palette.blueMask, -16777216);
                BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
                WritableRaster raster = bufferedImage.getRaster();
                int[] pixelArray = new int[4];
                int y = 0;
                while (y < data.height) {
                    int x = 0;
                    while (x < data.width) {
                        int pixel = data.getPixel(x, y);
                        RGB rgb = palette.getRGB(pixel);
                        pixelArray[0] = rgb.red;
                        pixelArray[1] = rgb.green;
                        pixelArray[2] = rgb.blue;
                        pixelArray[3] = data.getAlpha(x, y);
                        raster.setPixels(x, y, 1, 1, pixelArray);
                        ++x;
                    }
                    ++y;
                }
                return bufferedImage;
            }
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    pixelArray[0] = rgb.red;
                    pixelArray[1] = rgb.green;
                    pixelArray[2] = rgb.blue;
                    raster.setPixels(x, y, 1, 1, pixelArray);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] nArray = new int[4];
            nArray[3] = 255;
            int[] pixelArray = nArray;
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                    data.setAlpha(x, y, pixelArray[3]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof ComponentColorModel) {
            ComponentColorModel colorModel = (ComponentColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] nArray = new int[4];
            nArray[3] = 255;
            int[] pixelArray = nArray;
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                    data.setAlpha(x, y, pixelArray[3]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    public static ImageData _getImageDataFromRGBA(int width, int height, byte[] data) {
        int redMask = 65280;
        int greenMask = 0xFF0000;
        int blueMask = -16777216;
        PaletteData paletteData = new PaletteData(redMask, greenMask, blueMask);
        int maxByte = width * height * 4;
        int i = 0;
        while (i < maxByte) {
            byte t = data[i];
            data[i] = data[i + 2];
            data[i + 2] = t;
            i += 4;
        }
        ImageData imageData = new ImageData(width, height, 32, paletteData, 4, data);
        return imageData;
    }

    public static void convertToRGBA(ImageData imageData, ByteBuffer buffer) {
        int width = imageData.width;
        int height = imageData.height;
        if (!imageData.palette.isDirect || imageData.depth != 24) {
            ImageUtils.convertPaletteToRGB24(imageData);
        }
        boolean hasAlpha = false;
        if (imageData.alphaData != null) {
            hasAlpha = true;
        }
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                int index = j * width + i;
                RGB rgb = imageData.palette.getRGB(imageData.getPixel(i, j));
                buffer.put((byte)rgb.red);
                buffer.put((byte)rgb.green);
                buffer.put((byte)rgb.blue);
                if (hasAlpha) {
                    buffer.put(imageData.alphaData[index]);
                }
                ++i;
            }
            ++j;
        }
    }
}

