/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.utils;

import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.spreadsheet.resource.SpreadsheetResource;

public class SheetUtils {
    public static String getStringRepresentation(ReadGraph graph, Resource model, String sheetName, String range) throws DatabaseException {
        Resource configuration = graph.getPossibleObject(model, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
        Variable sheetVariable = null;
        for (Resource book : (Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, L0.ConsistsOf, SHEET.Book))) {
            for (Resource sheet : (Collection)graph.syncRequest((Read)new ObjectsWithType(book, L0.ConsistsOf, SHEET.Spreadsheet))) {
                if (!sheetName.equals(NameUtils.getSafeName((ReadGraph)graph, (Resource)sheet))) continue;
                sheetVariable = Variables.getVariable((ReadGraph)graph, (Resource)sheet);
            }
        }
        if (sheetVariable == null) {
            return null;
        }
        Variable rangeVariable = sheetVariable.getChild(graph, range);
        String[][] rangeCells = (String[][])rangeVariable.getPropertyValue(graph, "rangeCellNames");
        if (rangeCells == null || rangeCells[0].length <= 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        while (i < rangeCells.length) {
            sb.append("{");
            int j = 0;
            while (j < rangeCells[i].length) {
                String valueCell = rangeCells[i][j];
                Variable cell = sheetVariable.getChild(graph, valueCell);
                Variant valueVariant = (Variant)cell.getPropertyValue(graph, "content", (Binding)Bindings.VARIANT);
                Object valueObject = valueVariant.getValue();
                sb.append(valueObject.toString());
                if (j < rangeCells[i].length - 1) {
                    sb.append(", ");
                }
                ++j;
            }
            sb.append("}");
            if (i < rangeCells.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

