/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.utils;

import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.representation.Auxiliary;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.Input;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.Redeclaration;
import org.simantics.sysdyn.representation.Shadow;
import org.simantics.sysdyn.representation.Sheet;
import org.simantics.sysdyn.representation.Stock;
import org.simantics.sysdyn.representation.Valve;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.utils.ModuleSummary;

public class ModuleSummaryRequest
implements Read<ModuleSummary> {
    private Resource module;
    private boolean recursive;

    public ModuleSummaryRequest(Resource module, boolean recursive) {
        this.module = module;
        this.recursive = recursive;
    }

    public ModuleSummary perform(ReadGraph graph) throws DatabaseException {
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        StructuralResource2 SR2 = StructuralResource2.getInstance((ReadGraph)graph);
        ModuleSummary result = new ModuleSummary();
        if (this.module == null) {
            return result;
        }
        Object configuration = graph.isInstanceOf(this.module, SR.SysdynModel) ? graph.getPossibleObject(this.module, SIMU.HasConfiguration) : (graph.isInheritedFrom(this.module, SR.Module) ? graph.getPossibleObject(this.module, SR2.IsDefinedBy) : null);
        if (configuration == null) {
            return result;
        }
        SysdynModelManager smm = SysdynModelManager.getInstance(graph.getSession());
        SysdynModel sm = smm.getModel(graph, (Resource)configuration);
        sm.update(graph);
        result.add(this.collectSummary(sm.getConfiguration(), this.recursive, new HashMap<String, Integer>()));
        return result;
    }

    private ModuleSummary collectSummary(Configuration configuration, boolean recursive, Map<String, Integer> enumerationOverrides) {
        ModuleSummary result = new ModuleSummary();
        for (IElement e : configuration.getElements()) {
            if (e instanceof Input) {
                result.setInputs(result.getInputs() + 1);
            }
            if (e instanceof Auxiliary) {
                result.setAuxiliaries(result.getAuxiliaries() + 1);
            }
            if (e instanceof Stock) {
                result.setStocks(result.getStocks() + 1);
            }
            if (e instanceof Shadow) {
                result.setShadows(result.getShadows() + 1);
            }
            if (e instanceof Valve) {
                result.setValves(result.getValves() + 1);
            }
            if (e instanceof Enumeration) {
                result.setEnumerations(result.getEnumerations() + 1);
            }
            if (e instanceof Sheet) {
                result.setSheets(result.getSheets() + 1);
            }
            if (e instanceof Variable && !(e instanceof Sheet)) {
                result.setVariables(result.getVariables() + 1);
                int n = 1;
                Variable var = (Variable)e;
                if (var.getArrayIndexes() != null && var.getArrayIndexes().size() > 0) {
                    for (Enumeration enumeration : var.getArrayIndexes()) {
                        if (enumerationOverrides.containsKey(enumeration.getName())) {
                            n *= enumerationOverrides.get(enumeration.getName()).intValue();
                            continue;
                        }
                        n *= enumeration.getEnumerationIndexes().size();
                    }
                }
                result.setTotalVariables(result.getTotalVariables() + n);
            }
            if (!(e instanceof Module)) continue;
            result.setModules(result.getModules() + 1);
            if (!recursive) continue;
            Module m = (Module)e;
            HashMap<String, Integer> redeclarations = new HashMap<String, Integer>();
            for (Redeclaration redeclaration : m.getRedeclarations()) {
                int n = enumerationOverrides.containsKey(redeclaration.getReplacingEnumeration()) ? enumerationOverrides.get(redeclaration.getReplacingEnumeration()).intValue() : redeclaration.getReplacingEnumeration().getEnumerationIndexes().size();
                redeclarations.put(redeclaration.getReplacedEnumeration().getName(), n);
            }
            result.add(this.collectSummary(m.getType().getConfiguration(), recursive, redeclarations));
        }
        return result;
    }
}

