/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.elementaryCycles.ElementaryCyclesSearch;

public class LoopUtils {
    public static List<List<Resource>> getLoops(final Resource r) {
        List loops = Collections.emptyList();
        try {
            loops = (List)Simantics.getSession().syncRequest((Read)new Read<List<List<Resource>>>(){

                public List<List<Resource>> perform(ReadGraph graph) throws DatabaseException {
                    return LoopUtils.getLoops(graph, r);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return loops;
    }

    public static List<List<Resource>> getLoops(ReadGraph g, Resource r) throws DatabaseException, ServiceException {
        List<List<Resource>> cycles = LoopUtils.getAllLoopsInDiagram(g, r);
        ArrayList<List<Resource>> loops = new ArrayList<List<Resource>>();
        for (List<Resource> o : cycles) {
            List<Resource> loop;
            if (!(o instanceof List) || !(loop = o).contains(r)) continue;
            loops.add(loop);
        }
        return loops;
    }

    public static List<List<Resource>> getAllLoopsInDiagram(ReadGraph g, Resource r) throws DatabaseException, ServiceException {
        ArrayList<Object> dependingVariables;
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
        Resource configuration = g.getPossibleObject(r, l0.PartOf);
        if (configuration == null) {
            return Collections.emptyList();
        }
        Collection variables = g.getObjects(configuration, l0.ConsistsOf);
        ArrayList<Resource> shadows = new ArrayList<Resource>();
        Iterator it = variables.iterator();
        while (it.hasNext()) {
            Resource v = (Resource)it.next();
            if (g.isInstanceOf(v, sr.IndependentVariable)) continue;
            if (g.isInstanceOf(v, sr.Shadow)) {
                shadows.add(v);
                it.remove();
                continue;
            }
            it.remove();
        }
        int variableCount = variables.size();
        Object[] nodes = new Resource[variableCount];
        int k = 0;
        HashMap<Resource, ElementaryLoopItem> elementaryLoopItems = new HashMap<Resource, ElementaryLoopItem>();
        for (Resource variable : variables) {
            dependingVariables = new ArrayList();
            Collection collection = g.getObjects(variable, sr.Variable_isTailOf);
            for (Resource dependency : collection) {
                Resource head = g.getPossibleObject(dependency, sr.Variable_HasHead);
                if (head == null || g.isInstanceOf(head, sr.Module) || g.isInstanceOf(head, sr.Cloud) || (!g.isInstanceOf(dependency, sr.Flow) || !g.isInstanceOf(variable, sr.Valve)) && !g.isInstanceOf(dependency, sr.Dependency)) continue;
                dependingVariables.add(head);
            }
            Collection backwardFlows = g.getObjects(variable, sr.Variable_isHeadOf);
            for (Resource flow : backwardFlows) {
                Resource tail;
                if (!g.isInstanceOf(flow, sr.Flow) || (tail = g.getPossibleObject(flow, sr.Variable_HasTail)) == null || !g.isInstanceOf(tail, sr.Stock)) continue;
                dependingVariables.add(tail);
            }
            elementaryLoopItems.put(variable, new ElementaryLoopItem(k, dependingVariables));
            nodes[k++] = variable;
        }
        for (Resource shadow : shadows) {
            Resource original = g.getPossibleObject(shadow, sr.Shadow_original);
            ArrayList<Resource> arrayList = new ArrayList<Resource>();
            Collection dependencies = g.getObjects(shadow, sr.Variable_isTailOf);
            for (Resource dependency : dependencies) {
                Resource head = g.getPossibleObject(dependency, sr.Variable_HasHead);
                if (g.isInstanceOf(head, sr.Module)) continue;
                arrayList.add(head);
            }
            ElementaryLoopItem el = (ElementaryLoopItem)elementaryLoopItems.get(original);
            if (el == null) continue;
            el.dependencies.addAll(arrayList);
        }
        boolean[][] adjMatrix = new boolean[variableCount][variableCount];
        int j = 0;
        while (j < nodes.length) {
            dependingVariables = ((ElementaryLoopItem)elementaryLoopItems.get((Object)nodes[j])).dependencies;
            for (Resource resource : dependingVariables) {
                adjMatrix[j][((ElementaryLoopItem)elementaryLoopItems.get((Object)resource)).mapping] = true;
            }
            ++j;
        }
        ElementaryCyclesSearch ecs = new ElementaryCyclesSearch(adjMatrix, nodes);
        List cycles = ecs.getElementaryCycles();
        return cycles;
    }

    public static String cyclesToString(ReadGraph g, List<List<Resource>> cycles) throws DatabaseException {
        StringBuilder sb = new StringBuilder("");
        int i = 0;
        while (i < cycles.size()) {
            sb.append(LoopUtils.cycleToString(g, cycles.get(i)));
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public static String cycleToString(ReadGraph g, List<Resource> cycle) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        StringBuilder sb = new StringBuilder("");
        int j = 0;
        while (j < cycle.size()) {
            Resource node = cycle.get(j);
            if (j < cycle.size() - 1) {
                sb.append(g.getPossibleRelatedValue(node, l0.HasName, (Binding)Bindings.STRING) + " -> ");
            } else {
                sb.append((String)g.getPossibleRelatedValue(node, l0.HasName, (Binding)Bindings.STRING));
            }
            ++j;
        }
        return sb.toString();
    }

    public static LoopType getLoopType(ReadGraph graph, Resource resource) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        ModelingResources mod = ModelingResources.getInstance((ReadGraph)graph);
        Resource loopResource = graph.getPossibleObject(resource, sr.Loop_Items);
        if (loopResource == null) {
            return LoopType.UNDEFINED;
        }
        boolean oddNumberOfNegativeCausalities = false;
        List loop = ListUtils.toPossibleList((ReadGraph)graph, (Resource)loopResource);
        int i = 0;
        while (i < loop.size()) {
            boolean skipBackwardFlows = false;
            Collection forwardDependencies = graph.getObjects((Resource)loop.get(i), sr.Variable_isTailOf);
            Collection shadows = graph.getObjects((Resource)loop.get(i), sr.Shadow_original_Inverse);
            for (Resource shadow : shadows) {
                forwardDependencies.addAll(graph.getObjects(shadow, sr.Variable_isTailOf));
            }
            for (Resource dependency : forwardDependencies) {
                Resource dependencyConnection;
                Resource dependingVariable = graph.getSingleObject(dependency, sr.Variable_HasHead);
                if (!dependingVariable.equals(loop.get((i + 1) % loop.size())) || graph.isInstanceOf(dependency, sr.Flow)) continue;
                skipBackwardFlows = true;
                try {
                    dependencyConnection = graph.getSingleObject(dependency, mod.ConnectionToDiagramConnection);
                }
                catch (NoSingleResultException e) {
                    return LoopType.UNDEFINED;
                }
                String polarity = (String)graph.getPossibleRelatedValue(dependencyConnection, sr.DependencyConnection_polarity, (Binding)Bindings.STRING);
                if ("-".equals(polarity)) {
                    oddNumberOfNegativeCausalities = !oddNumberOfNegativeCausalities;
                    break;
                }
                if (polarity == null || "".equals(polarity) || "+".equals(polarity)) break;
                return LoopType.UNDEFINED;
            }
            if (!skipBackwardFlows) {
                Collection backwardFlows = graph.getObjects((Resource)loop.get(i), sr.Variable_isHeadOf);
                for (Resource flow : backwardFlows) {
                    Resource dependingVariable;
                    if (!graph.isInstanceOf(flow, sr.Flow) || !(dependingVariable = graph.getSingleObject(flow, sr.Variable_HasTail)).equals(loop.get((i + 1) % loop.size())) || !graph.isInstanceOf(dependingVariable, sr.Stock)) continue;
                    oddNumberOfNegativeCausalities = !oddNumberOfNegativeCausalities;
                    break;
                }
            }
            ++i;
        }
        return oddNumberOfNegativeCausalities ? LoopType.BALANCING : LoopType.REINFORCING;
    }

    private static class ElementaryLoopItem {
        public int mapping;
        ArrayList<Resource> dependencies;

        public ElementaryLoopItem(int mapping, ArrayList<Resource> dependencies) {
            this.mapping = mapping;
            this.dependencies = dependencies;
        }
    }

    public static enum LoopType {
        REINFORCING,
        BALANCING,
        UNDEFINED;

    }
}

