/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.unitParser.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import org.simantics.sysdyn.unitParser.UnitCheckingException;
import org.simantics.sysdyn.unitParser.UnitCheckingNode;
import org.simantics.sysdyn.unitParser.nodes.Expression;
import org.simantics.sysdyn.unitParser.nodes.FunctionArguments;
import org.simantics.sysdyn.unitParser.nodes.UnitResult;
import org.simantics.sysdyn.utils.Function;

public class ArrayDefinition
extends UnitCheckingNode {
    public ArrayDefinition(int id) {
        super(id);
    }

    @Override
    public UnitResult getUnits(HashMap<String, String> units, ArrayList<Function> functions, boolean allowEquivalents) throws UnitCheckingException {
        UnitResult result = new UnitResult(allowEquivalents);
        result.setUnitType(UnitResult.UnitType.SCALAR);
        UnitCheckingNode base = null;
        if (this.jjtGetNumChildren() > 0 && this.jjtGetChild(0) instanceof FunctionArguments) {
            FunctionArguments functionArguments = (FunctionArguments)this.jjtGetChild(0);
            for (UnitCheckingNode candidateNode : this.gatherExpressions(functionArguments, new ArrayList<UnitCheckingNode>())) {
                UnitResult candidateUnits = candidateNode.getUnits(units, functions, allowEquivalents);
                if (candidateUnits.getUnitType() == UnitResult.UnitType.SCALAR) continue;
                if (base == null) {
                    base = candidateNode;
                    UnitResult.UnitType oldUnitType = result.getUnitType();
                    result.appendResult(base.getUnits(units, functions, allowEquivalents));
                    UnitResult.UnitType newUnitType = result.getUnitType();
                    if (newUnitType != UnitResult.UnitType.SCALAR && newUnitType != UnitResult.UnitType.ANY && newUnitType != UnitResult.UnitType.DMNL) continue;
                    result.setUnitType(oldUnitType);
                    continue;
                }
                if (result.equals(candidateUnits)) continue;
                throw new UnitCheckingException("Array elements do not have same units: " + base.printNode() + " [" + result.getCleanFullUnit() + "] =/= " + candidateNode.printNode() + " [" + candidateUnits.getCleanFullUnit() + "]");
            }
        }
        return result;
    }

    private ArrayList<UnitCheckingNode> gatherExpressions(UnitCheckingNode functionArguments, ArrayList<UnitCheckingNode> expressions) {
        if (functionArguments.jjtGetNumChildren() > 0 && functionArguments.jjtGetChild(0) instanceof Expression) {
            expressions.add((UnitCheckingNode)functionArguments.jjtGetChild(0));
        }
        if (functionArguments.jjtGetNumChildren() > 1) {
            this.gatherExpressions((UnitCheckingNode)functionArguments.jjtGetChild(1), expressions);
        }
        return expressions;
    }
}

