/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation.utils;

import java.io.StringReader;
import java.util.ArrayList;
import org.simantics.sysdyn.expressionParser.ExpressionParser;
import org.simantics.sysdyn.expressionParser.ParseException;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.IndependentVariable;
import org.simantics.sysdyn.representation.Variability;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.representation.utils.IndexUtils;
import org.simantics.sysdyn.representation.utils.RepresentationUtils;
import org.simantics.sysdyn.representation.utils.SheetFormatUtils;

public class FormatUtils {
    public static String formatExpressionForModelica(Variable variable, String expression) {
        return FormatUtils.formatExpressionForModelica(variable, expression, true);
    }

    public static String formatExpressionForModelica(Variable variable, String expression, boolean gameAdditions) {
        String modified = expression;
        if (gameAdditions) {
            modified = FormatUtils.addGameExperimentAdditions(variable, modified);
        }
        modified = IndexUtils.equationRangesToIndexes(variable, modified);
        modified = SheetFormatUtils.reformatSheetReferences(variable, modified);
        return modified;
    }

    private static String addGameExperimentAdditions(Variable variable, String expression) {
        Variable reference;
        if (variable == null || !(variable instanceof IndependentVariable)) {
            return expression;
        }
        if (!RepresentationUtils.isPartOfGameExperiment(variable)) {
            return expression;
        }
        if (Variability.getVariability((IndependentVariable)variable).equals((Object)Variability.CONTINUOUS) && (reference = RepresentationUtils.getFirstGameVariableReference(variable, expression)) != null) {
            String condition;
            boolean array = reference.getArrayIndexes() != null && reference.getArrayIndexes() != null && !reference.getArrayIndexes().isEmpty();
            String refName = reference.getModelicaName();
            if (reference.getType().equals("Boolean")) {
                condition = "if initial() or " + refName + " or not " + refName + " then (";
            } else {
                if (array) {
                    refName = "sum(" + refName + ")";
                }
                condition = "if " + refName + " < 0 or " + refName + " >= 0 then (";
            }
            String conditionEnd = ") else " + FormatUtils.getZeros(variable);
            expression = String.valueOf(condition) + expression + conditionEnd;
        }
        return expression;
    }

    private static String getZeros(Variable variable) {
        ArrayList<Enumeration> enumerations = variable.getArrayIndexes();
        if (enumerations == null || enumerations.size() == 0) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("zeros(");
        boolean first = true;
        for (Enumeration e : enumerations) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(String.valueOf(e.getModelicaName()) + ".size");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String replaceWhitespace(String app) {
        String equation = app;
        ExpressionParser parser = new ExpressionParser(new StringReader(equation));
        String modifiedEquation = new String(equation);
        try {
            parser.expr();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ArrayList<String> allReferences = new ArrayList<String>();
        allReferences.addAll(parser.getReferences().keySet());
        allReferences.addAll(parser.getFunctionCallReferences().keySet());
        allReferences.addAll(parser.getEnumerationReferences().keySet());
        for (String reference : allReferences) {
            String regex = reference.replaceAll(" ", "(_|\\\\s+)");
            String replacement = reference.replaceAll(" ", "_");
            modifiedEquation = modifiedEquation.replaceAll(regex, replacement);
        }
        return modifiedEquation;
    }
}

