/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.mdl;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.sysdyn.modelImport.MdlUtil;
import org.simantics.sysdyn.modelImport.mdl.Declaration;
import org.simantics.sysdyn.modelImport.mdl.MdlModel;
import org.simantics.sysdyn.modelImport.model.support.Enumeration;

public class Subscript
extends Declaration {
    private static final String SUBSCRIPT_DECL = "([A-Za-z]\\w*(?:\\s+\\w+)*)\\s*(:|<->)\\s*([^~]*?)(\\s*~\\s*([^~]*?)\\s*~\\s*([^\\|]*?)\\s*\\|)";
    private static final int subscriptName = 1;
    private static final int subscriptType = 2;
    private static final int subscriptExpression = 3;
    private static final int subscriptSuffix = 4;
    private String original;
    private List<String> values;
    private Enumeration enumeration;

    protected Subscript(String name, MdlModel mdl, List<String> values) {
        super(name, mdl);
        this.original = null;
        this.values = values;
    }

    protected Subscript(String name, MdlModel mdl, String original) {
        super(name, mdl);
        this.original = original;
        this.values = null;
    }

    public static Subscript getPossible(String line, MdlModel mdl) throws Exception {
        Matcher matcher = Pattern.compile(SUBSCRIPT_DECL).matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        String name = MdlUtil.normalize(matcher.group(1));
        boolean equivalent = matcher.group(2).equals("<->");
        String expression = MdlUtil.normalize(matcher.group(3));
        Subscript subscript = equivalent ? new Subscript(name, mdl, expression) : new Subscript(name, mdl, Arrays.asList(expression.split(",")));
        subscript.parseSuffix(matcher.group(4));
        return subscript;
    }

    public String getOriginal() {
        return this.original;
    }

    public List<String> getValues() {
        if (this.values != null) {
            return this.values;
        }
        return this.getMdl().getSubscript(this.original).getValues();
    }

    public boolean isEquivalent() {
        return this.original != null;
    }

    public Enumeration getEnumeration() {
        if (this.enumeration == null) {
            this.enumeration = new Enumeration(this.getName(), this.getValues());
        }
        return this.enumeration;
    }
}

