/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.mdl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.sysdyn.modelImport.mdl.MdlVariable;
import org.simantics.sysdyn.modelImport.mdl.Sketch;
import org.simantics.sysdyn.modelImport.mdl.SketchElement;
import org.simantics.sysdyn.modelImport.mdl.SketchVariable;
import org.simantics.sysdyn.modelImport.model.Valve;

public class SketchValve
extends SketchElement {
    private static final String SKETCH_VALVE = "11,([+-]?\\d+),[+-]?\\d+,(([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),[+-]?\\d+,[+-]?\\d+,([+-]?\\d+),.*)";
    private static final int valveId = 1;
    private static final int valveSuffix = 2;
    private SketchVariable attached;

    protected SketchValve(int id, Sketch sketch) {
        super(id, sketch);
    }

    public static SketchValve getPossible(String line, Sketch sketch) throws Exception {
        Matcher matcher = Pattern.compile(SKETCH_VALVE).matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        int id = Integer.parseInt(matcher.group(1));
        SketchValve element = new SketchValve(id, sketch);
        element.parseSuffix(matcher.group(2));
        return element;
    }

    public SketchVariable getAttached() {
        return this.attached;
    }

    public void setAttached(SketchVariable attached) {
        this.attached = attached;
    }

    @Override
    public Valve getSymbol() {
        MdlVariable variable = this.getSketch().getMdl().getVariable(this.attached.getName());
        if (variable == null) {
            return null;
        }
        Valve valve = new Valve(Valve.Orientation.HORIZONTAL, this.getTextPosition());
        valve.setDimensions(this.getDimensions());
        return variable.initVariable(valve);
    }
}

