/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.mdl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.sysdyn.modelImport.MdlUtil;
import org.simantics.sysdyn.modelImport.mdl.Sketch;
import org.simantics.sysdyn.modelImport.mdl.SketchObject;
import org.simantics.sysdyn.modelImport.model.Symbol;
import org.simantics.sysdyn.modelImport.model.Valve;

public abstract class SketchElement
extends SketchObject {
    protected static final String ELEMENT_SUFFIX = "([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),[+-]?\\d+,[+-]?\\d+,([+-]?\\d+),.*";
    private static final int elementX = 1;
    private static final int elementY = 2;
    private static final int elementWidth = 3;
    private static final int elementHeight = 4;
    private static final int elementShape = 5;
    private static final int elementBits = 6;
    private static final int elementTextPos = 7;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean attached;
    private boolean allowsIn;
    private boolean allowsOut;
    private boolean inputOutput;
    private boolean textLine;
    private Valve.TextPosition textPosition;

    protected SketchElement(int id, Sketch sketch) {
        super(id, sketch);
    }

    protected void parseSuffix(String suffix) throws Exception {
        Matcher matcher = Pattern.compile(ELEMENT_SUFFIX).matcher(suffix);
        if (!matcher.matches()) {
            throw new Exception("could not parse element suffix " + suffix);
        }
        this.x = Integer.parseInt(matcher.group(1));
        this.y = Integer.parseInt(matcher.group(2));
        this.width = Integer.parseInt(matcher.group(3));
        this.height = Integer.parseInt(matcher.group(4));
        this.attached = (Integer.parseInt(matcher.group(5)) & 0x20) != 0;
        this.allowsIn = (Integer.parseInt(matcher.group(6)) & 1) != 0;
        this.allowsOut = (Integer.parseInt(matcher.group(6)) & 2) != 0;
        this.inputOutput = (Integer.parseInt(matcher.group(6)) & 8) != 0;
        this.textLine = (Integer.parseInt(matcher.group(6)) & 4) != 0;
        switch (Integer.parseInt(matcher.group(7))) {
            case 0: {
                this.textPosition = Valve.TextPosition.INSIDE;
                break;
            }
            case 1: {
                this.textPosition = Valve.TextPosition.BELOW;
                break;
            }
            case 2: {
                this.textPosition = Valve.TextPosition.LEFT;
                break;
            }
            case 3: {
                this.textPosition = Valve.TextPosition.ABOVE;
                break;
            }
            case 4: {
                this.textPosition = Valve.TextPosition.RIGHT;
                break;
            }
            default: {
                this.textPosition = Valve.TextPosition.UNSET;
            }
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTop() {
        return this.getY() - this.getHeight();
    }

    public int getBottom() {
        return this.getY() + this.getHeight();
    }

    public int getLeft() {
        return this.getX() - this.getWidth();
    }

    public int getRight() {
        return this.getX() + this.getWidth();
    }

    public boolean isAttached() {
        return this.attached;
    }

    public boolean allowsIn() {
        return this.allowsIn;
    }

    public boolean allowsOut() {
        return this.allowsOut;
    }

    public boolean isInputOutput() {
        return this.inputOutput;
    }

    public boolean hasTextLine() {
        return this.textLine;
    }

    public Valve.TextPosition getTextPosition() {
        return this.textPosition;
    }

    public abstract Symbol getSymbol();

    public double[] getDimensions() {
        return MdlUtil.getSysdynDimensions(this.getLeft() + this.getSketch().getElementXOffset(), this.getTop() + this.getSketch().getElementYOffset(), this.getWidth() * 2, this.getHeight() * 2);
    }
}

