/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.mdl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.sysdyn.modelImport.mdl.Sketch;
import org.simantics.sysdyn.modelImport.mdl.SketchElement;
import org.simantics.sysdyn.modelImport.mdl.SketchObject;
import org.simantics.sysdyn.modelImport.model.Connection;
import org.simantics.sysdyn.modelImport.model.Dependency;
import org.simantics.sysdyn.modelImport.model.Flow;
import org.simantics.sysdyn.modelImport.model.Symbol;

public class SketchConnection
extends SketchObject {
    private static final String POINTS = "(\\d+\\|(?:\\(-?\\d+,-?\\d+\\)\\|)+)";
    private static final String SKETCH_CONNECTION = "1,([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),[+-]?\\d+,[+-]?\\d+,[+-]?\\d+,[+-]?\\d+,[+-]?\\d+,[+-]?\\d+,[^,]*,[^,]*,(\\d+\\|(?:\\(-?\\d+,-?\\d+\\)\\|)+)";
    private static final int connectionId = 1;
    private static final int connectionFrom = 2;
    private static final int connectionTo = 3;
    private static final int connectionShape = 4;
    private static final int connectionPoints = 5;
    private static final String SAVE = "(-?\\d+),";
    private static final String SKIP = "-?\\d+,";
    public static final String sketchConnection = "1,(-?\\d+),(-?\\d+),(-?\\d+),(-?\\d+),-?\\d+,-?\\d+,-?\\d+,-?\\d+,-?\\d+,-?\\d+,[^,]*,[^,]*,(\\d+\\|(?:\\(-?\\d+,-?\\d+\\)\\|)+)";
    private int from;
    private int to;
    private ConnectionType type;
    int[] points;

    protected SketchConnection(int id, Sketch sketch, int from, int to, ConnectionType type, int[] points) {
        super(id, sketch);
        this.from = from;
        this.to = to;
        this.type = type;
        this.points = points;
    }

    public static SketchConnection getPossible(String line, Sketch sketch) throws Exception {
        ConnectionType type;
        Matcher matcher = Pattern.compile(SKETCH_CONNECTION).matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        int id = Integer.parseInt(matcher.group(1));
        int from = Integer.parseInt(matcher.group(2));
        int to = Integer.parseInt(matcher.group(3));
        int connType = Integer.parseInt(matcher.group(4));
        switch (Integer.parseInt(matcher.group(4))) {
            case 0: 
            case 1: {
                type = ConnectionType.ARROW;
                break;
            }
            case 4: {
                type = ConnectionType.LINE_ARROW;
                break;
            }
            case 100: {
                type = ConnectionType.LINE_SEGMENT;
                break;
            }
            default: {
                System.err.println("connection type " + connType + " not recognized");
                type = ConnectionType.OTHER;
            }
        }
        int[] points = SketchConnection.parsePoints(matcher.group(5));
        return new SketchConnection(id, sketch, from, to, type, points);
    }

    private static int[] parsePoints(String str) {
        int sep = str.indexOf(124);
        int count = Integer.parseInt(str.substring(0, sep));
        int[] points = new int[count * 2];
        int i = 0;
        while (i < count) {
            int start = sep + 1;
            sep = str.indexOf(124, start);
            String[] pair = str.substring(start + 1, sep - 1).split(",");
            points[i * 2] = Integer.parseInt(pair[0]);
            points[i * 2 + 1] = Integer.parseInt(pair[1]);
            ++i;
        }
        return points;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public int[] getPoints() {
        return this.points;
    }

    public Connection getConnection() {
        Symbol tail = (Symbol)this.getSketch().getObject(this.from).getModelObject();
        if (tail == null) {
            return null;
        }
        Symbol head = (Symbol)this.getSketch().getObject(this.to).getModelObject();
        if (head == null) {
            return null;
        }
        switch (this.type) {
            case ARROW: {
                return new Dependency(tail, head, true, false, this.getAngle(this.getSketch()));
            }
            case LINE_ARROW: {
                return new Flow(tail, head);
            }
            case LINE_SEGMENT: {
                return new Flow(head, tail);
            }
        }
        return null;
    }

    private double getAngle(Sketch sketch) {
        if (this.points == null || this.points.length < 2) {
            return 0.1;
        }
        SketchElement tail = (SketchElement)sketch.getObject(this.from);
        SketchElement head = (SketchElement)sketch.getObject(this.to);
        double x0 = tail.getX();
        double y0 = tail.getY();
        double x2 = head.getX();
        double y2 = head.getY();
        double x1 = this.points[0];
        double y1 = this.points[1];
        double dx0 = x1 - x0;
        double dy0 = y1 - y0;
        double dx1 = x1 - x2;
        double dy1 = y1 - y2;
        double dy = y2 - y0;
        double dx = x2 - x0;
        double dd = dx0 * dy - dy0 * dx;
        if (Math.abs(dd) < 0.01) {
            return 0.0;
        }
        double offset = (dx0 * dx1 + dy0 * dy1) / dd;
        double angle = 1.5707963267948966 - Math.atan(offset);
        if (dd > 0.0) {
            angle -= Math.PI;
        }
        return angle;
    }

    public static enum ConnectionType {
        ARROW,
        LINE_ARROW,
        LINE_SEGMENT,
        OTHER;

    }
}

