/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.mdl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.sysdyn.modelImport.mdl.Lookup;
import org.simantics.sysdyn.modelImport.mdl.MdlVariable;
import org.simantics.sysdyn.modelImport.mdl.Sketch;
import org.simantics.sysdyn.modelImport.mdl.Subscript;
import org.simantics.sysdyn.modelImport.mdl.SubscriptVariable;

public class MdlModel {
    private String name;
    private Map<String, MdlVariable> variables;
    private Map<String, ArrayList<MdlVariable>> groups;
    private Map<String, Lookup> lookups;
    private Map<String, Subscript> subscripts;
    private List<Sketch> sketches;

    public MdlModel(String name) {
        this.name = name;
        this.variables = new HashMap<String, MdlVariable>();
        this.groups = new HashMap<String, ArrayList<MdlVariable>>();
        this.lookups = new HashMap<String, Lookup>();
        this.subscripts = new HashMap<String, Subscript>();
        this.sketches = new ArrayList<Sketch>();
    }

    public String getName() {
        return this.name;
    }

    public void addVariable(MdlVariable variable, String group) throws Exception {
        if (this.variables.get(variable.getName()) != null) {
            throw new Exception("duplicate variable " + variable.getName());
        }
        this.variables.put(variable.getName(), variable);
        if (group != null) {
            if (this.groups.get(group) == null) {
                this.groups.put(group, new ArrayList());
            }
            this.groups.get(group).add(variable);
        }
    }

    public void addSubscriptVariable(SubscriptVariable variable, String group) throws Exception {
        MdlVariable original = this.variables.get(variable.getName());
        if (original != null) {
            if (!(original instanceof SubscriptVariable)) {
                throw new Exception("incompatible type for variable " + variable.getName());
            }
            ((SubscriptVariable)original).addSubscriptVariable(variable);
        } else {
            this.addVariable(variable, group);
        }
    }

    public MdlVariable getVariable(String name) {
        return this.variables.get(name);
    }

    public Set<MdlVariable> getAllVariables() {
        return new HashSet<MdlVariable>(this.variables.values());
    }

    public void addLookup(Lookup lookup) throws Exception {
        if (this.lookups.get(lookup.getName()) != null) {
            throw new Exception("duplicate lookup " + lookup.getName());
        }
        this.lookups.put(lookup.getName(), lookup);
    }

    public Lookup getLookup(String name) {
        return this.lookups.get(name);
    }

    public Set<Lookup> getAllLookups() {
        return new HashSet<Lookup>(this.lookups.values());
    }

    public void addSubscript(Subscript subscript) throws Exception {
        if (this.subscripts.get(subscript.getName()) != null) {
            throw new Exception("duplicate subscript " + subscript.getName());
        }
        this.subscripts.put(subscript.getName(), subscript);
    }

    public Subscript getSubscript(String name) {
        return this.subscripts.get(name);
    }

    public Set<Subscript> getAllSubscripts() {
        return new HashSet<Subscript>(this.subscripts.values());
    }

    public Subscript resolveSubscript(Set<String> values) {
        HashSet<String> all = new HashSet<String>();
        for (String value : values) {
            Subscript potential = this.subscripts.get(value);
            if (potential != null) {
                all.addAll(potential.getValues());
                continue;
            }
            all.add(value);
        }
        for (Subscript subscript : this.getAllSubscripts()) {
            if (subscript.isEquivalent() || !subscript.getValues().containsAll(all) || !all.containsAll(subscript.getValues())) continue;
            return subscript;
        }
        return null;
    }

    public void addSketch(Sketch sketch) {
        this.sketches.add(sketch);
    }

    public List<Sketch> getSketches() {
        return this.sketches;
    }
}

