/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelExport;

import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.Simantics;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.ModelDependenciesBean;
import org.simantics.db.layer0.util.ModelDependency;
import org.simantics.db.layer0.util.ModelTransferableGraphSource;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.SimanticsClipboardBuilder;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.utils.datastructures.hints.IHintContext;

public class SysdynModelExporter {
    private SysdynModelExporter() {
    }

    public static void exportModel(IProgressMonitor monitor, final Resource model, File exportLocation, String description, boolean dependencies) throws InvocationTargetException {
        try {
            final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            mon.beginTask("Exporting Sysdyn Model...", 100);
            THashMap tgExtensions = new THashMap();
            Session session = Simantics.getSession();
            if (dependencies) {
                session.syncRequest((Read)new ReadRequest((Map)tgExtensions){
                    private final /* synthetic */ Map val$tgExtensions;
                    {
                        this.val$tgExtensions = map;
                    }

                    public void run(ReadGraph graph) throws DatabaseException {
                        mon.setTaskName("Scanning model dependencies..");
                        mon.worked(10);
                        LinkedList<ModelDependency> modelDependencies = new LinkedList<ModelDependency>();
                        this.scanDependencies(graph, model, modelDependencies);
                        if (!modelDependencies.isEmpty()) {
                            this.val$tgExtensions.put(ModelDependenciesBean.EXTENSION_KEY, new Variant(ModelDependenciesBean.BINDING, (Object)new ModelDependenciesBean(modelDependencies.toArray(new ModelDependency[modelDependencies.size()]))));
                        }
                    }

                    private void scanDependencies(ReadGraph graph, Resource resource, LinkedList<ModelDependency> modelDependencies) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                        for (Resource library : (Collection)graph.syncRequest((Read)new ObjectsWithType(resource, L0.IsLinkedTo, MOD.SharedOntology))) {
                            String uri = graph.getPossibleURI(library);
                            if (uri == null) continue;
                            CopyHandler ch = (CopyHandler)graph.adapt(library, CopyHandler.class);
                            SimanticsClipboardImpl clipboard = new SimanticsClipboardImpl();
                            ch.copyToClipboard(graph, (SimanticsClipboardBuilder)clipboard, (IProgressMonitor)mon);
                            for (Set object : clipboard.getContents()) {
                                TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((ReadGraph)graph, (Set)object, (IHintContext.Key)SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
                                if (tg == null) continue;
                                modelDependencies.addFirst(new ModelDependency(uri, tg));
                            }
                            this.scanDependencies(graph, library, modelDependencies);
                        }
                    }
                });
            }
            mon.setTaskName("Creating transferable graph source...");
            mon.worked(10);
            ModelTransferableGraphSource source = (ModelTransferableGraphSource)session.sync((ReadInterface)new UniqueRead<ModelTransferableGraphSource>((Map)tgExtensions){
                private final /* synthetic */ Map val$tgExtensions;
                {
                    this.val$tgExtensions = map;
                }

                public ModelTransferableGraphSource perform(ReadGraph graph) throws DatabaseException {
                    mon.worked(10);
                    TransferableGraphConfiguration2 conf = new TransferableGraphConfiguration2(graph, model);
                    mon.worked(10);
                    if (!this.val$tgExtensions.isEmpty()) {
                        conf.baseExtensions.putAll(this.val$tgExtensions);
                    }
                    mon.worked(10);
                    return new ModelTransferableGraphSourceRequest(conf).perform(graph);
                }
            });
            mon.worked(10);
            mon.setTaskName("Writing metadata...");
            TreeMap<String, Variant> metadata = SysdynModelExporter.getModelExportMetadata(description);
            mon.worked(10);
            mon.setTaskName("Writing transferable graph...");
            try {
                TransferableGraphs.writeTransferableGraph((RequestProcessor)session, (String)".sysdyn", (int)1, metadata, (TransferableGraphSource)source, (File)exportLocation);
                mon.worked(20);
                source.closeStreams();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
            File[] fileArray = source.getFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                f.delete();
                ++n2;
            }
            mon.worked(10);
            mon.setTaskName("Done!");
        }
        catch (DatabaseException e) {
            throw new InvocationTargetException(e);
        }
    }

    private static TreeMap<String, Variant> getModelExportMetadata(String description) {
        TreeMap<String, Variant> metadata = new TreeMap<String, Variant>();
        metadata.put("date", Variant.ofInstance((Object)DateFormat.getDateTimeInstance(0, 0).format(new Date())));
        metadata.put("author", Variant.ofInstance((Object)System.getProperty("user.name", "")));
        metadata.put("description", Variant.ofInstance((Object)description));
        return metadata;
    }
}

