/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.modelica.data.DataSet;
import org.simantics.sysdyn.adapter.IndexVariable;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.sysdyn.manager.SysdynResult;

public class ActiveDatasetsIndexVariable
extends IndexVariable<ArrayList<DataSet>> {
    public ActiveDatasetsIndexVariable(ReadGraph graph, Variable parent, String indexes) throws DatabaseException {
        super(graph, parent, indexes);
    }

    @Override
    public ArrayList<DataSet> getValue() {
        ArrayList<DataSet> datasets = new ArrayList<DataSet>();
        if (this.experiment == null) {
            return datasets;
        }
        Collection<SysdynResult> results = this.experiment.getActiveResults();
        List<String> variableNamesWithIndexes = this.getVariableNamesWithIndexNumbers();
        List<String> variableNames = this.getVariableNames();
        int i = 0;
        while (i < variableNamesWithIndexes.size()) {
            for (SysdynResult result : results) {
                SysdynDataSet ds = result.getDataSet(variableNamesWithIndexes.get(i));
                if (ds == null) continue;
                ds.name = variableNames.get(i);
                datasets.add(ds);
            }
            ++i;
        }
        return datasets;
    }

    @Override
    public void setIndexedValue(WriteGraph graph, Object value) throws DatabaseException {
    }
}

