/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.function.All;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableMapImpl;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.adapter.ActiveDatasetsIndexVariable;
import org.simantics.sysdyn.adapter.NamesIndexVariable;
import org.simantics.sysdyn.adapter.TimeIndexVariable;
import org.simantics.sysdyn.adapter.TimesIndexVariable;
import org.simantics.sysdyn.adapter.ValueIndexVariable;
import org.simantics.sysdyn.adapter.ValueIndexVariableI;
import org.simantics.sysdyn.adapter.ValuesIndexVariable;

public class Functions {
    public static String VALUE = "value";
    public static String VALUES = "values";
    public static String TIME = "time";
    public static String TIMES = "times";
    public static String NAMES = "names";
    public static String ACTIVE_DATASETS = "activeDatasets";
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor valuePropertyValue = new ValueAccessor(){

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            return null;
        }

        public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
            return null;
        }

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
        }

        public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
        }

        public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
            return All.getDatatypeFromValue((ReadGraph)graph, (Variable)context);
        }
    };
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor equationPropertyValue = new ValueAccessor(){

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            return this.getValue(graph, context, (Binding)Bindings.STRING);
        }

        public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
            Variable v = context.getParent(graph);
            Resource represents = v.getPossibleRepresents(graph);
            if (represents != null) {
                SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
                List res = ListUtils.toList((ReadGraph)graph, (Resource)graph.getSingleObject(represents, SYSDYN.Variable_expressionList));
                if (res.size() == 1) {
                    Resource exp = (Resource)res.iterator().next();
                    String text = (String)graph.getRelatedValue(exp, SYSDYN.Expression_equation, (Binding)Bindings.STRING);
                    return text;
                }
            }
            return null;
        }

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            if (value instanceof Variant) {
                value = ((Variant)value).getValue();
            }
            if (!(value instanceof String)) {
                throw new DatabaseException("Unexpected value " + value + ", expected String");
            }
            this.setValue(graph, context, value, (Binding)Bindings.STRING);
        }

        public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
            if (value instanceof Variant) {
                value = ((Variant)value).getValue();
            }
            if (!(value instanceof String)) {
                throw new DatabaseException("Unexpected value " + value + ", expected String");
            }
            Variable v = context.getParent((ReadGraph)graph);
            Resource represents = v.getPossibleRepresents((ReadGraph)graph);
            if (represents != null) {
                SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
                List res = ListUtils.toList((ReadGraph)graph, (Resource)graph.getSingleObject(represents, SYSDYN.Variable_expressionList));
                if (res.size() == 1) {
                    Resource exp = (Resource)res.iterator().next();
                    graph.claimLiteral(exp, SYSDYN.Expression_equation, value, (Binding)Bindings.STRING);
                }
            }
        }

        public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
            return Datatypes.STRING;
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap runProperties = new VariableMapImpl(){

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            String property = context.getName(graph);
            if (TIME.equals(property)) {
                return new TimeIndexVariable(graph, context, name);
            }
            return null;
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            return map;
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap valuePropertyProperties = new VariableMapImpl(){

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            String property = context.getName(graph);
            if (VALUE.equals(property)) {
                if (name.startsWith("$")) {
                    Integer index = Integer.parseInt(name.substring(1));
                    return new ValueIndexVariableI(graph, context, index);
                }
                return new ValueIndexVariable(graph, context, name);
            }
            if (VALUES.equals(property)) {
                return new ValuesIndexVariable(graph, context, name);
            }
            if (TIMES.equals(property)) {
                return new TimesIndexVariable(graph, context, name);
            }
            if (TIME.equals(property)) {
                return new TimeIndexVariable(graph, context, name);
            }
            if (NAMES.equals(property)) {
                return new NamesIndexVariable(graph, context, name);
            }
            if (ACTIVE_DATASETS.equals(property)) {
                return new ActiveDatasetsIndexVariable(graph, context, name);
            }
            return null;
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            return map;
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap runChildren = new VariableMapImpl(){

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
            Map children = (Map)graph.syncRequest((Read)new StructuralChildMapOfResource(this.getConfiguration(graph, (Variable)variable)));
            Resource child = (Resource)children.get(name);
            if (child == null) {
                return All.getStandardChildDomainChildVariable((ReadGraph)graph, (Variable)context, (String)name);
            }
            return (Variable)graph.getPossibleContextualAdapter(child, (Object)variable, Variable.class, Variable.class);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
            map = All.getStandardChildDomainChildVariables((ReadGraph)graph, (Variable)context, map);
            for (Map.Entry entry : ((Map)graph.syncRequest((Read)new StructuralChildMapOfResource(this.getConfiguration(graph, (Variable)variable)))).entrySet()) {
                String name = (String)entry.getKey();
                Resource child = (Resource)entry.getValue();
                Variable var = (Variable)graph.getPossibleContextualAdapter(child, (Object)variable, Variable.class, Variable.class);
                if (var != null) {
                    if (map == null) {
                        map = new HashMap<String, Variable>();
                    }
                    map.put(name, var);
                    continue;
                }
                System.err.println("No adapter for " + child + " in " + variable.getURI(graph));
            }
            return map;
        }

        Resource getConfiguration(ReadGraph graph, Variable run) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            Resource experiment = graph.getPossibleObject(run.getRepresents(graph), L0.PartOf);
            Resource model = graph.getPossibleObject(experiment, L0.PartOf);
            return graph.getPossibleObject(model, L0X.HasBaseRealization);
        }
    };

    static class StructuralChildMapOfResource
    extends ResourceRead<Map<String, Resource>> {
        public StructuralChildMapOfResource(Resource resource) {
            super(resource);
        }

        public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
            Resource definition;
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Map directChildren = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(this.resource));
            Resource type = graph.getPossibleType(this.resource, STR.Component);
            if (type != null && (definition = graph.getPossibleObject(type, STR.IsDefinedBy)) != null) {
                return (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(definition));
            }
            return directChildren;
        }
    }
}

