/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn;

import java.io.File;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.simantics.sysdyn.manager.InternalGameExperimentFactory;
import org.simantics.sysdyn.solver.SolverSettings;
import org.simantics.sysdyn.solver.Solvers;

public class Activator
implements BundleActivator {
    private static BundleContext bundleContext;
    public static final String PLUGIN_ID = "org.simantics.sysdyn";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        File modelsDir = Activator.getBundleContext().getDataFile("models");
        if (!modelsDir.exists()) {
            modelsDir.mkdir();
        }
        plugin = this;
        Solvers.registerGameExperimentFactory(SolverSettings.SolverType.INTERNAL, new InternalGameExperimentFactory());
    }

    public void stop(BundleContext context) throws Exception {
        Solvers.unregisterGameExperimentFactory(SolverSettings.SolverType.INTERNAL);
        File modelsDir = Activator.getBundleContext().getDataFile("models");
        if (modelsDir.exists()) {
            Activator.recursiveDelete(modelsDir);
        }
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    private static boolean recursiveDelete(File fileOrDir) {
        if (fileOrDir.isDirectory()) {
            File[] fileArray = fileOrDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File innerFile = fileArray[n2];
                if (!Activator.recursiveDelete(innerFile)) {
                    return false;
                }
                ++n2;
            }
        }
        return fileOrDir.delete();
    }
}

