/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.wizards.models;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.utils.imports.ImportUtilsUI;

public class WizardModelsImportPage
extends WizardPage {
    private Text filePathField;
    private static String previouslyBrowsedFile = "";
    private Button browseDirectoriesButton;
    private Shell shell;

    public WizardModelsImportPage() {
        this("wizardModelsImportPage", null, null);
    }

    public WizardModelsImportPage(String pageName) {
        this(pageName, null, null);
    }

    public WizardModelsImportPage(String pageName, String initialPath, IStructuredSelection currentSelection) {
        super(pageName);
        this.setPageComplete(false);
        this.setTitle("Import Model");
        this.setDescription("Choose the Model file, then press Finish.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
    }

    private void createProjectsRoot(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText("Select Model source:");
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.filePathField = new Text(projectGroup, 2048);
        GridData directoryPathData = new GridData(4, 0, true, false);
        directoryPathData.widthHint = new PixelConverter((Control)this.filePathField).convertWidthInCharsToPixels(25);
        this.filePathField.setLayoutData((Object)directoryPathData);
        this.filePathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                previouslyBrowsedFile = WizardModelsImportPage.this.filePathField.getText();
            }
        });
        if (previouslyBrowsedFile != null) {
            this.filePathField.setText(previouslyBrowsedFile);
            this.validatePage();
        }
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText("Browse");
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardModelsImportPage.this.setErrorMessage(null);
                WizardModelsImportPage.this.handleLocationDirectoryButtonPressed();
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.filePathField.setFocus();
    }

    protected void handleLocationDirectoryButtonPressed() {
        this.shell = this.filePathField.getShell();
        FileDialog dialog = new FileDialog(this.shell, 4096);
        String[] ext = new String[]{"*.sysdyn; *.tg", "*.*"};
        dialog.setFilterExtensions(ext);
        dialog.setText("Import Model");
        String path = Activator.getDefault().getPreferenceStore().getString(ImportUtilsUI.IMPORTMODELTPATH);
        if (path.isEmpty() || !new File(path).exists()) {
            path = Platform.getLocation().toOSString();
        }
        dialog.setFilterPath(path);
        String selectedFile = dialog.open();
        if (selectedFile != null) {
            this.filePathField.setText(selectedFile);
            this.validatePage();
        }
    }

    public boolean createProjects() {
        Resource project = (Resource)Simantics.getProject().get();
        if (project == null) {
            this.setErrorMessage("Error when retrieving resource");
            return false;
        }
        String selected = previouslyBrowsedFile;
        if (selected == null) {
            this.setErrorMessage("No file selected");
            return false;
        }
        try {
            IStatus status = ImportUtilsUI.importModelFile(selected, null);
            if (status == null || !status.equals(Status.OK_STATUS)) {
                this.setErrorMessage(status.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    void validatePage() {
        if (previouslyBrowsedFile.isEmpty()) {
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

