/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.wizards.mdl;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.sysdyn.modelImport.MdlParser;
import org.simantics.sysdyn.modelImport.model.Model;
import org.simantics.sysdyn.modelImport.model.WriteContext;

public class WizardMdlImportPage
extends WizardPage {
    private Text filePathField;
    private static String previouslyBrowsedFile = "";
    private Button browseDirectoriesButton;

    public WizardMdlImportPage() {
        this("wizardMdlImportPage", null, null);
    }

    public WizardMdlImportPage(String pageName) {
        this(pageName, null, null);
    }

    public WizardMdlImportPage(String pageName, String initialPath, IStructuredSelection currentSelection) {
        super(pageName);
        this.setPageComplete(false);
        this.setTitle("Import Vensim model");
        this.setDescription("Choose the Vensim model file (.mdl), then press Finish.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
    }

    private void createProjectsRoot(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText("Select Vensim model source:");
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.filePathField = new Text(projectGroup, 2048);
        GridData directoryPathData = new GridData(4, 0, true, false);
        directoryPathData.widthHint = new PixelConverter((Control)this.filePathField).convertWidthInCharsToPixels(25);
        this.filePathField.setLayoutData((Object)directoryPathData);
        this.filePathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                previouslyBrowsedFile = WizardMdlImportPage.this.filePathField.getText();
            }
        });
        if (previouslyBrowsedFile != null) {
            this.filePathField.setText(previouslyBrowsedFile);
            this.validatePage();
        }
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText("Browse");
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardMdlImportPage.this.handleLocationDirectoryButtonPressed();
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.filePathField.setFocus();
    }

    protected void handleLocationDirectoryButtonPressed() {
        String selectedFile;
        Shell shell = this.filePathField.getShell();
        FileDialog dialog = new FileDialog(shell, 4096);
        String[] ext = new String[]{"*.mdl"};
        dialog.setFilterExtensions(ext);
        dialog.setText("Import Vensim model (.mdl)");
        String dirName = this.filePathField.getText().trim();
        File path = new File(dirName);
        if (path.exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedFile = dialog.open()) != null) {
            this.filePathField.setText(selectedFile);
            this.validatePage();
        }
    }

    public boolean createProjects() {
        Model model;
        final Resource project = (Resource)Simantics.getProject().get();
        if (project == null) {
            return false;
        }
        String selected = previouslyBrowsedFile;
        if (selected == null) {
            return false;
        }
        File file = new File(selected);
        try {
            model = new MdlParser().parse(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                model.write(graph, project, new WriteContext());
            }
        });
        return true;
    }

    void validatePage() {
        if (previouslyBrowsedFile.isEmpty()) {
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }
}

