/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.validation;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.expressionParser.ExpressionParser;
import org.simantics.sysdyn.expressionParser.ParseException;
import org.simantics.sysdyn.expressionParser.TokenMgrError;
import org.simantics.sysdyn.ui.validation.References;
import org.simantics.sysdyn.ui.validation.SyntaxErrorException;
import org.simantics.sysdyn.ui.validation.UndefinedExpressionException;
import org.simantics.sysdyn.ui.validation.UnsupportedCharactersException;

public class ValidationUtils {
    public static References getAllReferences(ReadGraph graph, Resource r) throws DatabaseException, SyntaxErrorException, UnsupportedCharactersException, UndefinedExpressionException {
        References result = new References();
        ExpressionParser parser = new ExpressionParser((Reader)new StringReader(""));
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        List<Resource> expressionList = ValidationUtils.getExpressions(graph, r);
        if (expressionList == null || expressionList.isEmpty()) {
            throw new UndefinedExpressionException();
        }
        for (Resource expression : expressionList) {
            Collection statements = graph.getStatements(expression, sr.Expression_equation);
            if (statements.isEmpty()) {
                throw new UndefinedExpressionException();
            }
            for (Statement statement : statements) {
                Object v = graph.getValue(statement.getObject());
                String value = v.toString();
                if (value.length() == 0 && !graph.isSubrelationOf(statement.getPredicate(), sr.HasEquationOrEmpty)) {
                    throw new UndefinedExpressionException();
                }
                parser.ReInit((Reader)new StringReader(value));
                try {
                    parser.expr();
                    HashMap refs = parser.getReferences();
                    result.references.put(expression, refs);
                    result.ranges.put(expression, parser.getRanges());
                    result.forIndices.put(expression, parser.getForIndices());
                    result.enumerationReferences.put(expression, parser.getEnumerationReferences());
                    result.functionReferences.put(expression, parser.getFunctionCallReferences());
                    result.expressions.put(expression, value);
                }
                catch (ParseException e1) {
                    throw new SyntaxErrorException();
                }
                catch (TokenMgrError err) {
                    throw new UnsupportedCharactersException();
                }
            }
        }
        return result;
    }

    public static List<Resource> getExpressions(ReadGraph graph, Resource r) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Resource hasExpressions = graph.getPossibleObject(r, sr.Variable_expressionList);
        if (hasExpressions != null) {
            return ListUtils.toList((ReadGraph)graph, (Resource)hasExpressions);
        }
        return null;
    }

    public static HashSet<String> getDependencies(ReadGraph graph, Resource r) throws DatabaseException {
        HashSet<String> variables = new HashSet<String>();
        if (graph != null && r != null) {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Collection dependencies = graph.getObjects(r, sr.Variable_isHeadOf);
            for (Resource d : dependencies) {
                Object name;
                Resource tail;
                if (!graph.isInstanceOf(d, sr.Dependency) && (!graph.isInstanceOf(d, sr.Flow) || !graph.isInstanceOf(r, sr.Stock)) || (tail = graph.getPossibleObject(d, sr.Variable_HasTail)) == null || graph.isInstanceOf(tail, sr.Shadow) && (tail = graph.getPossibleObject(tail, sr.Shadow_original)) == null || (name = graph.getPossibleRelatedValue(tail, l0.HasName)) == null) continue;
                variables.add((String)name);
            }
            Collection outgoingFlows = graph.getObjects(r, sr.Variable_isTailOf);
            for (Resource f : outgoingFlows) {
                Object name;
                Resource head;
                if (!graph.isInstanceOf(f, sr.Flow) || !graph.isInstanceOf(r, sr.Stock) || (head = graph.getPossibleObject(f, sr.Variable_HasHead)) == null || (name = graph.getPossibleRelatedValue(head, l0.HasName)) == null) continue;
                variables.add((String)name);
            }
        }
        return variables;
    }
}

