/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.utils;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.ui.utils.NameValidator;

public class FunctionLibraryNameValidator
extends NameValidator {
    @Override
    protected boolean nameIsTaken(ReadGraph graph, Resource functionLibrary, String name) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        if (functionLibrary == null) {
            return false;
        }
        Resource containingLibrary = graph.getPossibleObject(functionLibrary, l0.PartOf);
        if (containingLibrary == null) {
            return true;
        }
        if (graph.isInstanceOf(containingLibrary, sr.SysdynModel)) {
            Resource configurationResource = graph.getPossibleObject(containingLibrary, SIMU.HasConfiguration);
            if (configurationResource == null) {
                return true;
            }
            SysdynModel sysdynModel = SysdynModelManager.getInstance((Session)graph.getSession()).getModel(graph, configurationResource);
            sysdynModel.update(graph);
            if (this.nameTakenByTopLevelVariableOrModule(graph, sysdynModel, null, name)) {
                return true;
            }
            if (NameUtils.getSafeName((ReadGraph)graph, (Resource)containingLibrary).equals(name)) {
                return true;
            }
            if (this.nameTakenByBuiltInFunction(graph, name)) {
                return true;
            }
            if (this.nameTakenBySharedFunctionLibrary(graph, containingLibrary, null, name)) {
                return true;
            }
            if (this.nameTakenBySheet(sysdynModel, name)) {
                return true;
            }
        }
        return this.nameTakenByItemUnderLibrary(graph, containingLibrary, functionLibrary, name);
    }

    @Override
    public void renameInEquations(WriteGraph graph, Resource variable, String originalName, String newName) throws DatabaseException {
    }

    @Override
    public void renameInAllEquations(WriteGraph graph, Resource configuration, String originalName, String newName) throws DatabaseException {
    }
}

