/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.EnumerationIndex;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.ui.utils.SyntaxError;
import org.simantics.sysdyn.utils.ModelUtils;

public class ArrayVariableUtils {
    public static Map<Integer, SyntaxError> isRangeValid(ReadGraph graph, Variable variable, String[] elements) throws DatabaseException {
        SyntaxError error;
        if (variable == null) {
            return null;
        }
        HashMap<Integer, SyntaxError> result = new HashMap<Integer, SyntaxError>();
        if (variable.getArrayIndexes() == null || variable.getArrayIndexes() == null || variable.getArrayIndexes().size() == 0) {
            int i = 0;
            while (i < elements.length) {
                SyntaxError error2 = new SyntaxError();
                error2.setMessage("Variable is not an array variable");
                error2.setType("SyntaxError");
                result.put(i, error2);
                ++i;
            }
            return result;
        }
        ArrayList enumerations = variable.getArrayIndexes();
        if (elements.length > enumerations.size()) {
            error = new SyntaxError();
            error.setMessage("Too many elements");
            error.setType("SyntaxError");
            result.put(enumerations.size(), error);
        } else if (elements.length < enumerations.size()) {
            error = new SyntaxError();
            error.setMessage("Too few elements");
            error.setType("SyntaxError");
            result.put(elements.length > 0 ? elements.length - 1 : 0, error);
        }
        int i = 0;
        while (i < elements.length && i < enumerations.size()) {
            String trimmedElement = elements[i].trim();
            if (trimmedElement.length() != 0) {
                String[] rangeComponents;
                if (trimmedElement.charAt(0) == '{' && trimmedElement.charAt(trimmedElement.length() - 1) == '}') {
                    rangeComponents = trimmedElement.substring(1, trimmedElement.length() - 1).split(",");
                    if (rangeComponents.length != 1 || !rangeComponents[0].trim().equals(((Enumeration)enumerations.get(i)).getName())) {
                        result.putAll(ArrayVariableUtils.areRangeComponentsValid(rangeComponents, enumerations, i));
                    }
                } else if (!trimmedElement.equals(":")) {
                    if (elements[i].indexOf(":") != elements[i].lastIndexOf(":")) {
                        error = new SyntaxError();
                        error.setMessage("Too many ':' elements");
                        error.setType("SyntaxError");
                        result.put(i, error);
                    } else {
                        rangeComponents = elements[i].split(":");
                        if (rangeComponents.length > 2) {
                            error = new SyntaxError();
                            error.setMessage("Too many ':' elements");
                            error.setType("SyntaxError");
                            result.put(i, error);
                        } else if (rangeComponents.length != 1 || !rangeComponents[0].trim().equals(((Enumeration)enumerations.get(i)).getName())) {
                            result.putAll(ArrayVariableUtils.areRangeComponentsValid(rangeComponents, enumerations, i));
                        }
                    }
                }
            }
            ++i;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private static Map<Integer, SyntaxError> areRangeComponentsValid(String[] rangeComponents, ArrayList<Enumeration> enumerations, int i) {
        HashMap<Integer, SyntaxError> result = new HashMap<Integer, SyntaxError>();
        String[] stringArray = rangeComponents;
        int n = rangeComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            r = r.trim();
            boolean componentIsValid = false;
            Enumeration enumeration = enumerations.get(i);
            for (EnumerationIndex ei : enumeration.getEnumerationIndexes()) {
                if (!ei.getName().equals(r)) continue;
                componentIsValid = true;
                break;
            }
            if (!componentIsValid && r.length() > 0) {
                SyntaxError error;
                try {
                    int index = Integer.parseInt(r);
                    int min = 1;
                    int max = enumeration.getEnumerationIndexes().size();
                    if (index >= min && index <= max || enumeration.isReplaceable()) {
                        componentIsValid = true;
                        error = new SyntaxError();
                        error.setMessage("Using numbers as array indexes is not encouraged");
                        error.setType("SyntaxWarning");
                        result.put(i, error);
                    } else {
                        error = new SyntaxError();
                        error.setMessage("Invalid array index " + index + ". Numbered index must be between " + min + " and " + max);
                        error.setType("SyntaxError");
                        result.put(i, error);
                    }
                }
                catch (NumberFormatException e) {
                    error = new SyntaxError();
                    error.setMessage("Invalid range");
                    error.setType("SyntaxError");
                    result.put(i, error);
                }
            }
            ++n2;
        }
        return result;
    }

    public static boolean isRangeValid(ReadGraph graph, Resource variable, String range) throws DatabaseException {
        if (variable == null) {
            return true;
        }
        String[] elements = range.split(",");
        ArrayList<String> connectedElements = new ArrayList<String>();
        int i = 0;
        while (i < elements.length) {
            String lastElement = elements[i];
            String fullElement = new String();
            if (lastElement.length() > 0 && lastElement.charAt(0) == '{') {
                while (lastElement.charAt(lastElement.length() - 1) != '}' && i < elements.length - 1) {
                    fullElement = String.valueOf(fullElement) + lastElement + ",";
                    lastElement = elements[++i];
                }
            }
            fullElement = String.valueOf(fullElement) + lastElement;
            connectedElements.add(fullElement);
            ++i;
        }
        String[] fullElements = connectedElements.toArray(new String[connectedElements.size()]);
        SysdynModel model = ModelUtils.getModel((ReadGraph)graph, (Resource)variable);
        if (model == null) {
            return false;
        }
        IElement e = model.getElement(variable);
        if (e != null && e instanceof Variable) {
            Variable v = (Variable)e;
            return ArrayVariableUtils.isRangeValid(graph, v, fullElements) == null;
        }
        return false;
    }
}

