/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.expressions;

import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.simantics.sysdyn.ui.modelica.ModelicaSourceViewerConfiguration;
import org.simantics.sysdyn.ui.properties.widgets.expressions.CompletionProcessor;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionWidgetInput;

public class ExpressionFieldConfiguration
extends SourceViewerConfiguration {
    private final long WAIT_BEFORE_STATUS_CHANGE = 100L;
    Table allowedVariables;
    boolean allowFunctions;
    boolean assistSessionActive;
    CompletionProcessor completionProcessor;
    ResourceManager resourceManager;
    private final ExpressionWidgetInput input;

    public ExpressionFieldConfiguration(ResourceManager resourceManager, Table allowedVariables, boolean allowFunctions, ExpressionWidgetInput input) {
        this.resourceManager = resourceManager;
        this.allowedVariables = allowedVariables;
        this.allowFunctions = allowFunctions;
        this.assistSessionActive = false;
        this.completionProcessor = null;
        this.input = input;
    }

    public boolean isAssistSessionActive() {
        return this.assistSessionActive;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type"};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getTokenScanner());
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    ITokenScanner getTokenScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        Token reserved = new Token((Object)new TextAttribute(this.resourceManager.createColor(new RGB(127, 0, 85)), null, 1));
        Token defaultToken = new Token((Object)new TextAttribute(this.resourceManager.createColor(new RGB(0, 0, 0))));
        Token comment = new Token((Object)new TextAttribute(this.resourceManager.createColor(new RGB(63, 127, 95))));
        WordRule reservedWord = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isLetter(c);
            }

            public boolean isWordPart(char c) {
                return Character.isLetter(c);
            }
        }, (IToken)defaultToken);
        for (String s : ModelicaSourceViewerConfiguration.keywords) {
            reservedWord.addWord(s, (IToken)reserved);
        }
        IRule[] rules = new IRule[]{reservedWord, new MultiLineRule("/*", "*/", (IToken)comment), new MultiLineRule("\"", "\"", (IToken)comment)};
        scanner.setRules(rules);
        return scanner;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new DefaultTextHover(sourceViewer);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover();
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        this.completionProcessor = new CompletionProcessor(this.allowedVariables, this.allowFunctions, this.input);
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.completionProcessor, "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoInsert(true);
        assistant.setAutoActivationDelay(0);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.addCompletionListener((ICompletionListener)new CompletionListener());
        return assistant;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    private class CompletionListener
    implements ICompletionListener {
        private CompletionListener() {
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            if (event.processor.equals(ExpressionFieldConfiguration.this.completionProcessor)) {
                ExpressionFieldConfiguration.this.assistSessionActive = true;
            }
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            if (event.processor.equals(ExpressionFieldConfiguration.this.completionProcessor)) {
                Thread waitBeforeStateChange = new Thread(){

                    @Override
                    public void run() {
                        try {
                            1.sleep(100L);
                            ((CompletionListener)CompletionListener.this).ExpressionFieldConfiguration.this.assistSessionActive = false;
                        }
                        catch (InterruptedException e) {
                            ((CompletionListener)CompletionListener.this).ExpressionFieldConfiguration.this.assistSessionActive = false;
                        }
                    }
                };
                waitBeforeStateChange.start();
            }
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }
    }
}

