/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.arrays;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.graph.impl.contributor.viewpoint.ViewpointContributorImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.widgets.arrays.ConflictingEnumerationNode;
import org.simantics.sysdyn.ui.properties.widgets.arrays.EnumerationNode;

public class UsedEnumerations
extends ViewpointContributorImpl<ResourceArray> {
    public Collection<?> getContribution(ReadGraph graph, ResourceArray input) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Resource[] selection = input.resources;
        if (selection.length < 1) {
            return Collections.emptyList();
        }
        ArrayList<List> variableEnumerations = new ArrayList<List>();
        Resource[] resourceArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Resource variable = resourceArray[n2];
            Resource arrayIndexes = graph.getPossibleObject(variable, sr.Variable_arrayIndexesList);
            if (arrayIndexes != null) {
                variableEnumerations.add(ListUtils.toList((ReadGraph)graph, (Resource)arrayIndexes));
            } else {
                variableEnumerations.add(new ArrayList());
            }
            ++n2;
        }
        ArrayList enumerations = new ArrayList();
        int index = 0;
        while (true) {
            boolean b = true;
            for (List list : variableEnumerations) {
                if (index >= list.size()) continue;
                b = false;
                break;
            }
            if (b) break;
            for (List list : variableEnumerations) {
                if (index == enumerations.size()) {
                    enumerations.add(index, new ArrayList());
                }
                Resource enumeration = index < list.size() ? (Resource)list.get(index) : null;
                ((List)enumerations.get(index)).add(enumeration);
            }
            ++index;
        }
        ArrayList<AbstractNode> result = new ArrayList<AbstractNode>();
        if (enumerations.size() == 1 && (((List)enumerations.get(0)).size() == 0 || ((List)enumerations.get(0)).size() == 1 && ((List)enumerations.get(0)).get(0) == null)) {
            return result;
        }
        for (List list : enumerations) {
            boolean same = true;
            int i = 0;
            while (i < list.size() - 1) {
                if (list.get(i) == null || list.get(i + 1) == null || !((Resource)list.get(i)).equals(list.get(i + 1))) {
                    same = false;
                    break;
                }
                ++i;
            }
            if (!same) {
                result.add(new ConflictingEnumerationNode(list.toArray(new Resource[list.size()])));
                continue;
            }
            result.add(new EnumerationNode((Resource)list.get(0)));
        }
        return result;
    }

    public String getViewpointId() {
        return "Used enumerations";
    }
}

