/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.simantics.browsing.ui.swt.widgets.TrackedCombo;
import org.simantics.browsing.ui.swt.widgets.impl.ComboModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;

public class UnitComboWidget
extends TrackedCombo {
    public UnitComboWidget(Composite parent, WidgetSupport support, int style) {
        super(parent, support, style);
        this.setItemFactory((ReadFactory)new ReadFactoryImpl<Resource, Map<String, Object>>(){

            public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {
                HashMap<String, Object> map = new HashMap<String, Object>();
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                Resource model = graph.getPossibleObject(input, l0.PartOf);
                if (model != null) {
                    Collection variables = graph.getObjects(model, l0.ConsistsOf);
                    for (Resource v : variables) {
                        Object unit = graph.getPossibleRelatedValue(v, sr.Variable_unit);
                        if (unit == null || map.keySet().contains(unit)) continue;
                        map.put((String)unit, (String)unit);
                    }
                }
                return map;
            }
        });
        this.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, String>(){

            public String perform(ReadGraph graph, Resource input) throws DatabaseException {
                String unit = (String)graph.getPossibleRelatedValue(input, SysdynResource.getInstance((ReadGraph)graph).Variable_unit);
                if (unit == null) {
                    return "";
                }
                return unit;
            }
        });
        this.addModifyListener((TextModifyListener)new ComboModifyListenerImpl<Resource>(){

            public void applyText(WriteGraph graph, Resource input, String text) throws DatabaseException {
                graph.denyValue(input, SysdynResource.getInstance((ReadGraph)graph).Variable_unit);
                graph.claimLiteral(input, SysdynResource.getInstance((ReadGraph)graph).Variable_unit, (Object)text);
                Resource conf = graph.getPossibleObject(input, Layer0.getInstance((ReadGraph)graph).PartOf);
                SysdynModelManager smm = SysdynModelManager.getInstance((Session)graph.getSession());
                SysdynModel sm = smm.getModel((ReadGraph)graph, conf);
                sm.getMapping().domainModified(input);
                sm.update((ReadGraph)graph);
            }
        });
    }
}

