/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.TrackedCombo;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ComboModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.jfreechart.chart.properties.LabelPropertyTabContributor;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.ui.properties.widgets.IsOutputWidget;
import org.simantics.sysdyn.ui.properties.widgets.UnitComboWidget;
import org.simantics.sysdyn.ui.properties.widgets.factories.DoublePropertyFactory;
import org.simantics.sysdyn.ui.properties.widgets.factories.DoublePropertyModifier;
import org.simantics.sysdyn.ui.properties.widgets.factories.VariableNameInputValidator;
import org.simantics.sysdyn.ui.properties.widgets.factories.VariableNamePropertyModifier;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.validators.DoubleValidator;

public class InputVariableTab
extends LabelPropertyTabContributor {
    public InputVariableTab(Object id) {
        super(id);
    }

    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        Composite composite = new Composite(body, 0);
        GridDataFactory.fillDefaults().hint(200, -1).grab(false, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo(composite);
        TrackedText nameText = new TrackedText(composite, support, 2048);
        nameText.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasName"));
        nameText.addModifyListener((TextModifyListener)new VariableNamePropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasName"));
        nameText.setInputValidator((IInputValidator)new VariableNameInputValidator(support));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameText.getWidget());
        Composite defaultValueComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)defaultValueComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(defaultValueComposite);
        Label label = new Label(defaultValueComposite, 0);
        label.setText("Default Value:");
        TrackedText defaultValue = new TrackedText(defaultValueComposite, support, 133120);
        defaultValue.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/Input/defaultInputValue"));
        defaultValue.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/Input/defaultInputValue"));
        defaultValue.setInputValidator((IInputValidator)new DoubleValidator());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)defaultValue.getWidget());
        Composite unitComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)unitComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(unitComposite);
        label = new Label(unitComposite, 0);
        label.setText("Unit:");
        GridDataFactory.fillDefaults().applyTo((Control)label);
        UnitComboWidget unitCombo = new UnitComboWidget(unitComposite, support, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)unitCombo.getWidget());
        Composite variabilityComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)variabilityComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(variabilityComposite);
        label = new Label(variabilityComposite, 0);
        label.setText("Variability:");
        TrackedCombo variability = new TrackedCombo(variabilityComposite, support, 2060);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)variability.getWidget());
        this.setVariabilityFactories(variability);
        new IsOutputWidget(composite, support, 0);
    }

    private void setVariabilityFactories(TrackedCombo variability) {
        variability.setItemFactory((ReadFactory)new ReadFactoryImpl<Resource, Map<String, Object>>(){

            public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("continuous", "continuous");
                map.put("parameter", "parameter");
                map.put("constant", "constant");
                return map;
            }
        });
        variability.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, String>(){

            public Object getIdentity(Object inputContents) {
                return new Pair(inputContents, ((Object)((Object)this)).getClass());
            }

            public String perform(ReadGraph graph, Resource input) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                String variability = (String)graph.getPossibleRelatedValue(input, sr.Variable_variability);
                if (variability == null || variability.isEmpty()) {
                    return "continuous";
                }
                return variability;
            }
        });
        variability.addModifyListener((TextModifyListener)new ComboModifyListenerImpl<Resource>(){

            public void applyText(WriteGraph graph, Resource input, String text) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                String variability = text;
                if (text.equals("continuous")) {
                    variability = "";
                }
                if (variability != null) {
                    graph.denyValue(input, sr.Variable_variability);
                    graph.claimLiteral(input, sr.Variable_variability, (Object)variability);
                    Resource conf = graph.getPossibleObject(input, Layer0.getInstance((ReadGraph)graph).PartOf);
                    SysdynModelManager smm = SysdynModelManager.getInstance((Session)graph.getSession());
                    SysdynModel sm = smm.getModel((ReadGraph)graph, conf);
                    sm.getMapping().domainModified(input);
                    sm.update((ReadGraph)graph);
                }
            }
        });
    }
}

