/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedCombo;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.jfreechart.chart.properties.AdjustableTab;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.widgets.EquivalentUnitsWidget;
import org.simantics.sysdyn.ui.properties.widgets.factories.ComboStringPropertyModifier;
import org.simantics.sysdyn.ui.properties.widgets.factories.DoublePropertyFactory;
import org.simantics.sysdyn.ui.properties.widgets.factories.DoublePropertyModifier;
import org.simantics.sysdyn.ui.properties.widgets.factories.ModelNameInputValidator;

public class ConfigurationTab
extends AdjustableTab {
    private ScrolledComposite sc;
    private Label nameLabel;
    private Label startTimeLabel;
    private Label stopTimeLabel;
    private Label stepLengthLabel;
    private Label outputIntervalLabel;
    private Label methodLabel;
    private Label toleranceLabel;
    private Label variableFilterLabel;
    private TrackedText name;
    private TrackedText startTime;
    private TrackedText stopTime;
    private TrackedText stepLength;
    private TrackedText outputInterval;
    private TrackedText tolerance;
    private TrackedText variableFilter;
    private TrackedCombo method;
    private TrackedCombo timeUnit;
    private Button validateUnits;
    private Button useModelicaLibrary;
    private EquivalentUnitsWidget equivalentUnitsWidget;

    public ConfigurationTab(Object id) {
        super(id);
    }

    protected void createAndAddControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        this.sc = new ScrolledComposite(body, 768);
        this.composite = new Composite((Composite)this.sc, 0);
        this.sc.setContent((Control)this.composite);
        this.nameLabel = new Label(this.composite, 0);
        this.nameLabel.setText("Name");
        this.name = new TrackedText(this.composite, support, 2048);
        this.name.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasLabel"));
        this.name.addModifyListener((TextModifyListener)new ModelLabelModifier(context, "http://www.simantics.org/Layer0-1.1/HasLabel"));
        this.name.setInputValidator((IInputValidator)new ModelNameInputValidator(support));
        this.startTimeLabel = new Label(this.composite, 0);
        this.startTimeLabel.setText("Start time");
        this.startTime = new TrackedText(this.composite, support, 133120);
        this.startTime.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/SysdynModel/startTime"));
        this.startTime.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/SysdynModel/startTime"));
        this.startTime.setInputValidator((IInputValidator)new DoubleValidator());
        this.stopTimeLabel = new Label(this.composite, 0);
        this.stopTimeLabel.setText("Stop time");
        this.stopTime = new TrackedText(this.composite, support, 133120);
        this.stopTime.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/SysdynModel/stopTime"));
        this.stopTime.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/SysdynModel/stopTime"));
        this.stopTime.setInputValidator((IInputValidator)new DoubleValidator());
        this.stepLengthLabel = new Label(this.composite, 0);
        this.stepLengthLabel.setText("Step length\n(empty = default)");
        this.stepLength = new TrackedText(this.composite, support, 133120);
        this.stepLength.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/SysdynModel/simulationStepLength"));
        this.stepLength.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/SysdynModel/simulationStepLength"));
        this.stepLength.setInputValidator((IInputValidator)new DoubleValidator());
        this.outputIntervalLabel = new Label(this.composite, 0);
        this.outputIntervalLabel.setText("Output interval\n(empty = all steps)");
        this.outputIntervalLabel.setAlignment(131072);
        this.outputInterval = new TrackedText(this.composite, support, 133120);
        this.outputInterval.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/SysdynModel/outputInterval"));
        this.outputInterval.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/SysdynModel/outputInterval"));
        this.outputInterval.setInputValidator((IInputValidator)new DoubleValidator());
        this.methodLabel = new Label(this.composite, 0);
        this.methodLabel.setText("Method");
        this.method = new TrackedCombo(this.composite, support, 2060);
        this.method.setItemFactory((ReadFactory)new ReadFactoryImpl<Resource, Map<String, Object>>(){

            public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("euler", "euler");
                map.put("rungekutta", "rungekutta");
                map.put("dassl", "dassl");
                map.put("optimization", "optimization");
                map.put("radau5", "radau5");
                map.put("radau3", "radau3");
                map.put("radau1", "radau1");
                map.put("lobatto2", "lobatto2");
                map.put("lobatto4", "lobatto4");
                map.put("lobatto6", "lobatto6");
                map.put("qss", "qss");
                return map;
            }
        });
        this.method.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, String>(){

            public String perform(ReadGraph graph, Resource input) throws DatabaseException {
                String s = (String)graph.getPossibleRelatedValue(input, SysdynResource.getInstance((ReadGraph)graph).SysdynModel_solver);
                return s != null ? s : "";
            }
        });
        this.method.addModifyListener((TextModifyListener)new ComboStringPropertyModifier<Resource>(){

            @Override
            public void applyText(WriteGraph graph, Resource input, String text) throws DatabaseException {
                graph.claimLiteral(input, SysdynResource.getInstance((ReadGraph)graph).SysdynModel_solver, (Object)text);
            }
        });
        this.validateUnits = new Button(this.composite, support, 32);
        this.validateUnits.setText("Validate units");
        this.validateUnits.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, Boolean>(){

            public Boolean perform(ReadGraph graph, Resource model) throws DatabaseException {
                Resource unitIssueSource = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(model, Layer0X.getInstance((ReadGraph)graph).Activates, SysdynResource.getInstance((ReadGraph)graph).Validations_Units_UnitIssueSource));
                if (unitIssueSource == null) {
                    return false;
                }
                Boolean result = (Boolean)graph.getPossibleRelatedValue(unitIssueSource, IssueResource.getInstance((ReadGraph)graph).IssueSource_active, (Binding)Bindings.BOOLEAN);
                return Boolean.TRUE.equals(result);
            }
        });
        this.validateUnits.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource model) throws DatabaseException {
                boolean enabled;
                Resource unitIssueSource = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(model, Layer0X.getInstance((ReadGraph)graph).Activates, SysdynResource.getInstance((ReadGraph)graph).Validations_Units_UnitIssueSource));
                IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
                Boolean result = (Boolean)graph.getPossibleRelatedValue(unitIssueSource, ISSUE.IssueSource_active, (Binding)Bindings.BOOLEAN);
                if (result == null) {
                    result = false;
                }
                graph.claimLiteral(unitIssueSource, ISSUE.IssueSource_active, (Object)Boolean.FALSE.equals(result));
                boolean bl = enabled = result == false;
                if (!ConfigurationTab.this.equivalentUnitsWidget.getWidget().isDisposed()) {
                    ConfigurationTab.this.equivalentUnitsWidget.getWidget().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ConfigurationTab.this.equivalentUnitsWidget.getWidget().isDisposed()) {
                                ConfigurationTab.this.equivalentUnitsWidget.getWidget().setEnabled(enabled);
                            }
                        }
                    });
                }
            }
        });
        this.timeUnit = new TrackedCombo(this.composite, support, 2060);
        this.timeUnit.setItemFactory((ReadFactory)new ReadFactoryImpl<Resource, Map<String, Object>>(){

            public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("year", "year");
                map.put("month", "month");
                map.put("week", "week");
                map.put("day", "day");
                map.put("hour", "hour");
                map.put("min", "min");
                map.put("s", "s");
                return map;
            }
        });
        this.timeUnit.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, String>(){

            public String perform(ReadGraph graph, Resource input) throws DatabaseException {
                String s = (String)graph.getPossibleRelatedValue(input, SysdynResource.getInstance((ReadGraph)graph).SysdynModel_timeUnit);
                return s != null ? s : "month";
            }
        });
        this.timeUnit.addModifyListener((TextModifyListener)new ComboStringPropertyModifier<Resource>(){

            @Override
            public void applyText(WriteGraph graph, Resource input, String text) throws DatabaseException {
                graph.claimLiteral(input, SysdynResource.getInstance((ReadGraph)graph).SysdynModel_timeUnit, (Object)text);
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Modified " + graph.getRelatedValue2(input, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING) + " time unit to " + text));
            }
        });
        this.equivalentUnitsWidget = new EquivalentUnitsWidget(this.composite, support, 0);
        this.toleranceLabel = new Label(this.composite, 0);
        this.toleranceLabel.setText("Tolerance");
        this.tolerance = new TrackedText(this.composite, support, 133120);
        this.tolerance.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/SysdynModel/tolerance"));
        this.tolerance.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/SysdynModel/tolerance"));
        this.tolerance.setInputValidator((IInputValidator)new DoubleValidator());
        this.variableFilterLabel = new Label(this.composite, 0);
        this.variableFilterLabel.setText("Variable filter");
        this.variableFilterLabel.setToolTipText("Variable filter as regular expression.\nTo include variables Auxiliary1, Auxiliary2 and Auxiliary3: \nAuxiliary[1-3]\nor\nAuxiliary1|Auxiliary2|Auxiliary3\nNOTE: whitespace must be replaced with an underscore ('_') charactere.g. 'Growth Rate' -> 'Growth_Rate'");
        this.variableFilter = new TrackedText(this.composite, support, 2048);
        this.variableFilter.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Sysdyn-1.1/SysdynModel/variableFilter", ""));
        this.variableFilter.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/SysdynModel/variableFilter"));
        this.variableFilter.getWidget().setToolTipText("Variable filter as regular expression.\nTo include variables Auxiliary1, Auxiliary2 and Auxiliary3: \nAuxiliary[1-3]\nor\nAuxiliary1|Auxiliary2|Auxiliary3\nNOTE: whitespace must be replaced with an underscore ('_') charactere.g. 'Growth Rate' -> 'Growth_Rate'");
        this.useModelicaLibrary = new Button(this.composite, support, 32);
        this.useModelicaLibrary.setText("Use Modelica libraries");
        this.useModelicaLibrary.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, Boolean>(){

            public Boolean perform(ReadGraph graph, Resource model) throws DatabaseException {
                SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                SimulationResource SIM = SimulationResource.getInstance((ReadGraph)graph);
                Resource configuration = graph.getPossibleObject(model, SIM.HasConfiguration);
                if (configuration == null) {
                    return null;
                }
                if (graph.getPossibleObject(configuration, SR.SysdynModel_useModelicaLibraries) != null) {
                    return true;
                }
                return false;
            }
        });
        this.useModelicaLibrary.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource model) throws DatabaseException {
                boolean useModelicaLibraries;
                SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                SimulationResource SIM = SimulationResource.getInstance((ReadGraph)graph);
                Resource configuration = graph.getPossibleObject(model, SIM.HasConfiguration);
                boolean bl = useModelicaLibraries = graph.getPossibleObject(configuration, SR.SysdynModel_useModelicaLibraries) != null;
                if (!useModelicaLibraries) {
                    graph.claim(configuration, SR.SysdynModel_useModelicaLibraries, configuration);
                } else {
                    graph.deny(configuration, SR.SysdynModel_useModelicaLibraries);
                }
            }
        });
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
    }

    protected void createControlLayoutVertical() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sc);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.sc);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(this.composite);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.nameLabel);
        GridDataFactory.fillDefaults().grab(true, false).hint(50, -1).applyTo((Control)this.name.getWidget());
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.startTimeLabel);
        GridDataFactory.fillDefaults().grab(true, false).hint(50, -1).applyTo((Control)this.startTime.getWidget());
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.stopTimeLabel);
        GridDataFactory.fillDefaults().grab(true, false).hint(50, -1).applyTo((Control)this.stopTime.getWidget());
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.stepLengthLabel);
        this.stepLengthLabel.setAlignment(16384);
        GridDataFactory.fillDefaults().grab(true, false).hint(50, -1).applyTo((Control)this.stepLength.getWidget());
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.outputIntervalLabel);
        this.outputIntervalLabel.setAlignment(16384);
        GridDataFactory.fillDefaults().grab(true, false).hint(50, -1).applyTo((Control)this.outputInterval.getWidget());
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.methodLabel);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.validateUnits.getWidget());
        GridDataFactory.fillDefaults().span(2, 1).align(1, 0x1000000).applyTo((Control)this.equivalentUnitsWidget.getWidget());
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.toleranceLabel);
        GridDataFactory.fillDefaults().grab(true, false).hint(50, -1).applyTo((Control)this.tolerance.getWidget());
        GridDataFactory.fillDefaults().span(2, 1).align(1, 0x1000000).applyTo((Control)this.variableFilterLabel);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).hint(100, -1).applyTo((Control)this.variableFilter.getWidget());
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).hint(100, -1).applyTo((Control)this.useModelicaLibrary.getWidget());
        this.sc.setMinSize(this.composite.computeSize(-1, -1));
    }

    protected void createControlLayoutHorizontal(boolean wideScreen) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sc);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.sc);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(wideScreen ? 13 : 6).applyTo(this.composite);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.nameLabel);
        GridDataFactory.fillDefaults().grab(true, false).span(wideScreen ? 12 : 5, 1).hint(200, -1).applyTo((Control)this.name.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.startTimeLabel);
        GridDataFactory.fillDefaults().grab(true, false).hint(50, -1).applyTo((Control)this.startTime.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.stopTimeLabel);
        GridDataFactory.fillDefaults().grab(true, false).hint(50, -1).applyTo((Control)this.stopTime.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.stepLengthLabel);
        this.stepLengthLabel.setAlignment(131072);
        GridDataFactory.fillDefaults().grab(true, false).hint(50, -1).applyTo((Control)this.stepLength.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.outputIntervalLabel);
        this.outputIntervalLabel.setAlignment(131072);
        GridDataFactory.fillDefaults().grab(true, false).hint(50, -1).applyTo((Control)this.outputInterval.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.methodLabel);
        GridDataFactory.fillDefaults().span(wideScreen ? 1 : 3, 1).align(1, 0x1000000).applyTo((Control)this.method.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.validateUnits.getWidget());
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.timeUnit.getWidget());
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.equivalentUnitsWidget.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.toleranceLabel);
        GridDataFactory.fillDefaults().grab(true, false).span(wideScreen ? 1 : 2, 1).hint(60, -1).applyTo((Control)this.tolerance.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.variableFilterLabel);
        GridDataFactory.fillDefaults().grab(true, false).span(wideScreen ? 9 : 4, 1).hint(200, -1).applyTo((Control)this.variableFilter.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.useModelicaLibrary.getWidget());
        this.sc.setMinSize(this.composite.computeSize(-1, -1));
    }

    private class DoubleValidator
    implements IInputValidator {
        private DoubleValidator() {
        }

        public String isValid(String newText) {
            int i = 0;
            while (i < newText.length()) {
                if (!Character.isDigit(newText.charAt(i))) {
                    if (newText.charAt(i) != '.') {
                        return "Invalid character '" + newText.charAt(i) + "'";
                    }
                    if (newText.indexOf(46) != newText.lastIndexOf(46)) {
                        return "There can be only one '.'";
                    }
                }
                ++i;
            }
            return null;
        }
    }

    private class ModelLabelModifier
    extends TextModifyListenerImpl<Resource> {
        public ModelLabelModifier(ISessionContext context, String propertyURI) {
        }

        public void applyText(WriteGraph graph, Resource issue, String text) throws DatabaseException {
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            graph.claimLiteral(issue, l0.HasLabel, (Object)text);
            String safeName = NameUtils.findFreshName((ReadGraph)graph, (String)text, (Resource)graph.getSingleObject(issue, l0.PartOf), (Resource)l0.ConsistsOf, (String)"%s%d");
            graph.claimLiteral(issue, l0.HasName, (Object)safeName);
        }
    }
}

