/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.browsing.ui.swt.SingleSelectionInputSource;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.properties.LabelPropertyTabContributor;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.widgets.ColumnKeys;
import org.simantics.utils.RunnableWithObject;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.threads.SWTThread;

public class ArrayIndexesTab
extends LabelPropertyTabContributor
implements Widget {
    GraphExplorerComposite availableEnumerationsExplorer;
    GraphExplorerComposite usedEnumerationsExplorer;
    private WidgetSupportImpl buttonSupport;
    private org.simantics.browsing.ui.swt.widgets.Label usedEnumerationsLabel;
    private Button down;
    private Button up;
    private Button remove;

    public ArrayIndexesTab(Object variables) {
        super(variables);
    }

    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        support.register((Widget)this);
        this.buttonSupport = new WidgetSupportImpl();
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(body);
        Composite available = new Composite(body, 0);
        GridLayoutFactory.fillDefaults().applyTo(available);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)available);
        Label label = new Label(available, 0);
        label.setText("Available Enumerations");
        this.availableEnumerationsExplorer = new GraphExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), site, available, 67586);
        this.availableEnumerationsExplorer.setBrowseContexts(new String[]{"http://www.simantics.org/Sysdyn-1.1/AvailableVariableIndexes"});
        this.availableEnumerationsExplorer.setColumns(ColumnKeys.ENUMERATION_TABLE_COLUMNS);
        this.availableEnumerationsExplorer.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(ResourceArray.class));
        this.availableEnumerationsExplorer.finish();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.availableEnumerationsExplorer);
        Control c = (Control)this.availableEnumerationsExplorer.getExplorerControl();
        if (c instanceof Tree) {
            ((Tree)c).setLinesVisible(true);
        }
        Button add = new Button(body, (WidgetSupport)this.buttonSupport, 0);
        add.setText(" -> ");
        add.addSelectionListener((SelectionListener)new SelectionListenerImpl<ResourceArray>(context){
            List<Resource> enumerationResources;

            public void beforeApply() {
                this.enumerationResources = ArrayIndexesTab.this.getSelectedResources(ArrayIndexesTab.this.availableEnumerationsExplorer);
            }

            public void apply(WriteGraph graph, ResourceArray input) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Resource[] resourceArray = input.resources;
                int n = input.resources.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource r = resourceArray[n2];
                    Resource arrayIndexes = graph.getPossibleObject(r, sr.Variable_arrayIndexesList);
                    StringBuilder sb = new StringBuilder();
                    sb.append("Added new enumeration(s) ");
                    if (arrayIndexes == null) {
                        arrayIndexes = ListUtils.create((WriteGraph)graph, this.enumerationResources);
                        graph.claim(r, sr.Variable_arrayIndexesList, arrayIndexes);
                        sb.append(String.valueOf(this.enumerationResources.toString()) + " ");
                    } else {
                        ArrayList<Resource> filtered = new ArrayList<Resource>();
                        for (Resource enumeration : this.enumerationResources) {
                            if (ListUtils.getNode((ReadGraph)graph, (Resource)arrayIndexes, (Resource)enumeration) != null) continue;
                            filtered.add(enumeration);
                            sb.append(graph.getPossibleRelatedValue2(enumeration, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING) + " ");
                        }
                        if (filtered.isEmpty()) {
                            return;
                        }
                        ListUtils.insertBack((WriteGraph)graph, (Resource)arrayIndexes, filtered);
                    }
                    sb.append("to " + graph.getPossibleRelatedValue2(r, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING));
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)sb.toString());
                    ArrayIndexesTab.this.updateUsedButtons((ReadGraph)graph, arrayIndexes);
                    ++n2;
                }
            }
        });
        Composite used = new Composite(body, 0);
        GridLayoutFactory.fillDefaults().applyTo(used);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)used);
        this.usedEnumerationsLabel = new org.simantics.browsing.ui.swt.widgets.Label(used, (WidgetSupport)this.buttonSupport, 0);
        this.usedEnumerationsLabel.setTextFactory((ReadFactory)new ReadFactoryImpl<ResourceArray, String>(){

            public String perform(ReadGraph graph, ResourceArray input) throws DatabaseException {
                if (input.size() < 2) {
                    return "Used Enumerations";
                }
                StringBuilder sb = new StringBuilder();
                sb.append("Enumerations in: ");
                boolean first = true;
                for (Resource r : input) {
                    if (!first) {
                        sb.append(", ");
                    }
                    first = false;
                    String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
                    sb.append(name);
                }
                return sb.toString();
            }
        });
        this.usedEnumerationsExplorer = new GraphExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), site, used, 67586);
        this.usedEnumerationsExplorer.setBrowseContexts(new String[]{"http://www.simantics.org/Sysdyn-1.1/UsedVariableIndexes"});
        this.usedEnumerationsExplorer.setColumns(ColumnKeys.ENUMERATION_TABLE_COLUMNS);
        this.usedEnumerationsExplorer.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(ResourceArray.class));
        this.usedEnumerationsExplorer.finish();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.usedEnumerationsExplorer);
        Control c2 = (Control)this.usedEnumerationsExplorer.getExplorerControl();
        if (c2 instanceof Tree) {
            ((Tree)c2).setLinesVisible(true);
        }
        Composite buttons = new Composite(body, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttons);
        this.up = new Button(buttons, (WidgetSupport)this.buttonSupport, 0);
        this.up.setText("Up");
        this.up.addSelectionListener((SelectionListener)new SelectionListenerImpl<ResourceArray>(context){
            List<Integer> selectedIndexes;

            public void beforeApply() {
                this.selectedIndexes = ArrayIndexesTab.this.getSelectedIndexes(ArrayIndexesTab.this.usedEnumerationsExplorer);
            }

            public void apply(WriteGraph graph, ResourceArray input) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                for (Resource variable : input) {
                    Resource arrayIndexes = graph.getPossibleObject(variable, sr.Variable_arrayIndexesList);
                    if (arrayIndexes == null) continue;
                    List enumerations = ListUtils.toList((ReadGraph)graph, (Resource)arrayIndexes);
                    ArrayList<Resource> toBeMoved = new ArrayList<Resource>();
                    StringBuilder sb = new StringBuilder();
                    sb.append("Moved enumeration(s) ");
                    for (Integer index : this.selectedIndexes) {
                        if (index >= enumerations.size()) continue;
                        Resource enumeration = (Resource)enumerations.get(index);
                        toBeMoved.add(enumeration);
                    }
                    boolean moved = false;
                    for (Resource enumeration : toBeMoved) {
                        Resource node = ListUtils.getNode((ReadGraph)graph, (Resource)arrayIndexes, (Resource)enumeration);
                        Resource prev = graph.getSingleObject(node, L0.List_Previous);
                        if (arrayIndexes.equals(prev) || toBeMoved.contains(graph.getPossibleObject(prev, L0.List_Element))) continue;
                        sb.append(graph.getPossibleRelatedValue2(enumeration, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING) + " ");
                        moved = ListUtils.swapWithPrevious((WriteGraph)graph, (Resource)arrayIndexes, (Resource)enumeration);
                    }
                    if (!moved) continue;
                    sb.append("up");
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)sb.toString());
                }
                ArrayIndexesTab.this.usedEnumerationsExplorer.getDisplay().asyncExec((Runnable)new RunnableWithObject(ArrayIndexesTab.this.usedEnumerationsExplorer, this.selectedIndexes){

                    public void run() {
                        Control c = (Control)((GraphExplorerComposite)this.object).getExplorerControl();
                        if (c != null && c instanceof Tree && this.object2 instanceof List) {
                            Tree tree = (Tree)c;
                            tree.deselectAll();
                            List list = (List)this.object2;
                            HashSet<TreeItem> selection = new HashSet<TreeItem>();
                            for (Integer i : list) {
                                TreeItem item = null;
                                if (i - 1 >= 0) {
                                    item = tree.getItem(i - 1);
                                }
                                if (item == null || selection.contains(item)) {
                                    item = tree.getItem(i.intValue());
                                }
                                if (item == null || selection.contains(item)) continue;
                                selection.add(item);
                            }
                            tree.setSelection(selection.toArray(new TreeItem[selection.size()]));
                        }
                    }
                });
            }
        });
        this.down = new Button(buttons, (WidgetSupport)this.buttonSupport, 0);
        this.down.setText("Down");
        this.down.addSelectionListener((SelectionListener)new SelectionListenerImpl<ResourceArray>(context){
            List<Integer> selectedIndexes;

            public void beforeApply() {
                this.selectedIndexes = ArrayIndexesTab.this.getSelectedIndexes(ArrayIndexesTab.this.usedEnumerationsExplorer);
            }

            public void apply(WriteGraph graph, ResourceArray input) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                for (Resource variable : input) {
                    Resource arrayIndexes = graph.getPossibleObject(variable, sr.Variable_arrayIndexesList);
                    if (arrayIndexes == null) continue;
                    List enumerations = ListUtils.toList((ReadGraph)graph, (Resource)arrayIndexes);
                    ArrayList<Resource> toBeMoved = new ArrayList<Resource>();
                    StringBuilder sb = new StringBuilder();
                    sb.append("Moved enumeration(s) ");
                    for (Integer index : this.selectedIndexes) {
                        if (index >= enumerations.size()) continue;
                        Resource enumeration = (Resource)enumerations.get(index);
                        toBeMoved.add(0, enumeration);
                    }
                    boolean moved = false;
                    for (Resource enumeration : toBeMoved) {
                        Resource node = ListUtils.getNode((ReadGraph)graph, (Resource)arrayIndexes, (Resource)enumeration);
                        Resource next = graph.getSingleObject(node, L0.List_Next);
                        if (arrayIndexes.equals(next) || toBeMoved.contains(graph.getPossibleObject(next, L0.List_Element))) continue;
                        sb.append(graph.getPossibleRelatedValue2(enumeration, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING) + " ");
                        moved = ListUtils.swapWithNext((WriteGraph)graph, (Resource)arrayIndexes, (Resource)enumeration);
                    }
                    if (!moved) continue;
                    sb.append("down");
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)sb.toString());
                }
                ArrayIndexesTab.this.usedEnumerationsExplorer.getDisplay().asyncExec((Runnable)new RunnableWithObject(ArrayIndexesTab.this.usedEnumerationsExplorer, this.selectedIndexes){

                    public void run() {
                        Control c = (Control)((GraphExplorerComposite)this.object).getExplorerControl();
                        if (c != null && c instanceof Tree && this.object2 instanceof List) {
                            Tree tree = (Tree)c;
                            tree.deselectAll();
                            List list = (List)this.object2;
                            HashSet<TreeItem> selection = new HashSet<TreeItem>();
                            Collections.reverse(list);
                            for (Integer i : list) {
                                TreeItem item = null;
                                if (i + 1 < tree.getItemCount()) {
                                    item = tree.getItem(i + 1);
                                }
                                if (item == null || selection.contains(item)) {
                                    item = tree.getItem(i.intValue());
                                }
                                if (item == null || selection.contains(item)) continue;
                                selection.add(item);
                            }
                            tree.setSelection(selection.toArray(new TreeItem[selection.size()]));
                        }
                    }
                });
            }
        });
        this.remove = new Button(buttons, (WidgetSupport)this.buttonSupport, 0);
        this.remove.setText("Remove");
        this.remove.addSelectionListener((SelectionListener)new SelectionListenerImpl<ResourceArray>(context){
            List<Integer> selectedIndexes;

            public void beforeApply() {
                this.selectedIndexes = ArrayIndexesTab.this.getSelectedIndexes(ArrayIndexesTab.this.usedEnumerationsExplorer);
            }

            public void apply(WriteGraph graph, ResourceArray input) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                for (Resource variable : input) {
                    Resource arrayIndexes = graph.getPossibleObject(variable, sr.Variable_arrayIndexesList);
                    if (arrayIndexes == null) continue;
                    List enumerations = ListUtils.toList((ReadGraph)graph, (Resource)arrayIndexes);
                    ArrayList<Resource> toBeRemoved = new ArrayList<Resource>();
                    for (Integer index : this.selectedIndexes) {
                        if (index >= enumerations.size()) continue;
                        Resource enumeration = (Resource)enumerations.get(index);
                        toBeRemoved.add(enumeration);
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("Removed enumeration(s) ");
                    for (Resource enumeration : toBeRemoved) {
                        ListUtils.removeElement((WriteGraph)graph, (Resource)arrayIndexes, (Resource)enumeration);
                        sb.append(graph.getPossibleRelatedValue2(enumeration, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING) + " ");
                    }
                    sb.append("from " + graph.getPossibleRelatedValue2(variable, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING));
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)sb.toString());
                    ArrayIndexesTab.this.updateUsedButtons((ReadGraph)graph, arrayIndexes);
                }
            }
        });
    }

    protected void updateUsedButtons(ReadGraph graph, Resource arrayIndexes) {
        boolean enabled = false;
        if (arrayIndexes == null) {
            enabled = false;
        } else {
            try {
                List currEnumerations = ListUtils.toList((ReadGraph)graph, (Resource)arrayIndexes);
                if (!currEnumerations.isEmpty()) {
                    enabled = true;
                }
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
        final boolean finalEnabled = enabled;
        SWTThread.getThreadAccess().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ArrayIndexesTab.this.up.getControl().isDisposed()) {
                    ArrayIndexesTab.this.up.getControl().setEnabled(finalEnabled);
                }
                if (!ArrayIndexesTab.this.down.getControl().isDisposed()) {
                    ArrayIndexesTab.this.down.getControl().setEnabled(finalEnabled);
                }
                if (!ArrayIndexesTab.this.remove.getControl().isDisposed()) {
                    ArrayIndexesTab.this.remove.getControl().setEnabled(finalEnabled);
                }
            }
        });
    }

    private List<Resource> getSelectedResources(GraphExplorerComposite explorer) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        ISelection selection = ((ISelectionProvider)explorer.getAdapter(ISelectionProvider.class)).getSelection();
        if (selection == null) {
            return result;
        }
        IStructuredSelection iss = (IStructuredSelection)selection;
        List selections = iss.toList();
        for (AdaptableHintContext ahc : selections) {
            Resource resource = (Resource)ahc.getAdapter(Resource.class);
            result.add(resource);
        }
        return result;
    }

    private List<Integer> getSelectedIndexes(final GraphExplorerComposite explorer) {
        final ArrayList<Integer> result = new ArrayList<Integer>();
        explorer.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Control c = (Control)explorer.getExplorerControl();
                if (c instanceof Tree) {
                    TreeItem[] selection;
                    Tree tree = (Tree)c;
                    TreeItem[] treeItemArray = selection = tree.getSelection();
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        result.add(tree.indexOf(item));
                        ++n2;
                    }
                }
            }
        });
        return result;
    }

    public void setInput(ISessionContext context, Object input) {
        if (input != null && input instanceof IStructuredSelection) {
            Object first = ((IStructuredSelection)input).getFirstElement();
            ResourceArray resourceArray = null;
            if (first instanceof Resource) {
                resourceArray = new ResourceArray(new Resource[]{(Resource)first});
            } else if (first instanceof Collection) {
                resourceArray = new ResourceArray(((Collection)first).toArray(new Resource[((Collection)first).size()]));
            }
            final ResourceArray finalResourceArray = resourceArray;
            if (resourceArray != null) {
                StructuredSelection selection = new StructuredSelection((Object)finalResourceArray);
                this.availableEnumerationsExplorer.setInput(context, (Object)selection);
                this.usedEnumerationsExplorer.setInput(context, (Object)selection);
                this.buttonSupport.fireInput(context, (Object)selection);
                try {
                    context.getSession().syncRequest((Read)new ReadRequest(){

                        public void run(ReadGraph graph) throws DatabaseException {
                            Resource r = finalResourceArray.resources[0];
                            Resource arrayIndexes = graph.getPossibleObject(r, SysdynResource.getInstance((ReadGraph)graph).Variable_arrayIndexesList);
                            ArrayIndexesTab.this.updateUsedButtons(graph, arrayIndexes);
                        }
                    });
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

