/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.simulationPlayback;

import java.net.URL;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.simantics.Simantics;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.manager.SysdynPlaybackExperiment;
import org.simantics.sysdyn.ui.Activator;

public class PlaybackExperimentHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND = "org.simantics.sysdyn.ui.playback";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment == null || !(experiment instanceof SysdynPlaybackExperiment)) {
            return null;
        }
        SysdynPlaybackExperiment spe = (SysdynPlaybackExperiment)experiment;
        if (!spe.isPlaybackRunning()) {
            spe.startPlayback();
        } else {
            spe.stopPlayback();
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment == null || !(experiment instanceof SysdynPlaybackExperiment)) {
            return;
        }
        SysdynPlaybackExperiment spe = (SysdynPlaybackExperiment)experiment;
        ExperimentState state = experiment.getState();
        if (state == ExperimentState.RUNNING && !spe.isPlaybackRunning()) {
            this.setBaseEnabled(false);
        } else {
            this.setBaseEnabled(true);
        }
        if (spe.isPlaybackRunning()) {
            element.setIcon(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/control_pause.png")));
            element.setHoverIcon(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/control_pause_blue.png")));
        } else {
            long duration = spe.getPlaybackDuration();
            if (duration == SysdynPlaybackExperiment.DURATION_SLOW) {
                element.setIcon(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/control_step.png")));
                element.setHoverIcon(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/control_step_blue.png")));
            } else if (duration == SysdynPlaybackExperiment.DURATION_FAST) {
                element.setIcon(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/control_fastforward.png")));
                element.setHoverIcon(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/control_fastforward_blue.png")));
            } else {
                element.setIcon(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/control_play.png")));
                element.setHoverIcon(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/control_play_blue.png")));
            }
        }
    }
}

