/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.game;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.simantics.Simantics;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.ui.utils.HandlerUtils;

public class StepHandler
extends AbstractHandler
implements IElementUpdater {
    public static String COMMAND = "org.simantics.sysdyn.ui.step";
    private boolean started = false;
    private boolean initialized = false;
    private boolean running = false;

    private SysdynGameExperimentBase getGameExperiment() {
        IProject project = Simantics.peekProject();
        if (project == null) {
            return null;
        }
        IExperimentManager manager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment active = manager.getActiveExperiment();
        if (!(active instanceof SysdynGameExperimentBase)) {
            return null;
        }
        return (SysdynGameExperimentBase)active;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        HandlerUtils.saveBeforeExperimentRun(event);
        SysdynGameExperimentBase game = this.getGameExperiment();
        if (game != null) {
            game.simulateDuration(game.getStepDuration());
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        SysdynGameExperimentBase game = this.getGameExperiment();
        if (game == null) {
            this.started = false;
            this.initialized = false;
            return;
        }
        ExperimentState state = game.getState();
        if (state == ExperimentState.INITIALIZING) {
            this.started = false;
            this.initialized = false;
            this.running = false;
        } else if (state == ExperimentState.RUNNING) {
            this.started = true;
            this.initialized = this.initialized;
            this.running = true;
        } else if (state == ExperimentState.STOPPED) {
            if (this.started && !this.initialized) {
                this.initialized = true;
            }
            this.running = false;
        }
        if (this.initialized) {
            if (!this.running) {
                this.setBaseEnabled(true);
            } else {
                this.setBaseEnabled(false);
            }
            element.setTooltip("Step");
        } else {
            this.setBaseEnabled(false);
            element.setTooltip("Initialize Game First");
        }
    }
}

