/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.exports;

import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class ExportExternalFunctionFilesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Resource[] resources = ResourceAdaptionUtils.toResources((Object)sel);
        if (resources.length < 1) {
            return null;
        }
        return ExportExternalFunctionFilesHandler.exportFiles(shell, resources);
    }

    public static Object exportFiles(Shell shell, final Resource[] resources) {
        DirectoryDialog dd = new DirectoryDialog(shell);
        dd.setFilterPath(Platform.getLocation().toOSString());
        dd.setText("Export files to...");
        dd.setMessage("Select a directory");
        final String dir = dd.open();
        if (dir == null) {
            return null;
        }
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Resource[] resourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource r = resourceArray[n2];
                    try {
                        String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
                        FileOutputStream fos = new FileOutputStream(String.valueOf(dir) + "\\" + name);
                        byte[] fileBArray = (byte[])graph.getPossibleRelatedValue(r, sr.ExternalFunctionFile_externalFile, (Binding)Bindings.BYTE_ARRAY);
                        fos.write(fileBArray);
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            }
        });
        return null;
    }
}

