/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers;

import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class ToggleResultSetActivation
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Resource[] resources = ResourceAdaptionUtils.toResources((Object)sel);
        if (resources.length == 0) {
            return null;
        }
        ToggleResultSetActivation.toggleActivation(resources);
        return null;
    }

    public static void toggleActivation(final Resource[] resources) {
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    Resource[] resourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Resource r = resourceArray[n2];
                        boolean resultShown = false;
                        Collection results = graph.getObjects(r, sr.Experiment_result);
                        for (Resource result : results) {
                            if (!graph.hasStatement(result, sr.Result_showResult)) continue;
                            resultShown = true;
                            break;
                        }
                        for (Resource result : results) {
                            if (resultShown) {
                                graph.denyStatement(result, sr.Result_showResult, result);
                                continue;
                            }
                            graph.claim(result, sr.Result_showResult, result);
                        }
                        ++n2;
                    }
                }
            });
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }
}

