/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modelica.data.DataSet;
import org.simantics.modelica.data.SimulationResult;
import org.simantics.modeling.ModelingUtils;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.sysdyn.manager.MemoryResult;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.manager.SysdynResult;
import org.simantics.sysdyn.ui.handlers.SaveHistoryDialog;
import org.simantics.sysdyn.ui.utils.HandlerUtils;
import org.simantics.utils.datastructures.Pair;

public class SaveHistoryHandler
extends AbstractHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        HandlerUtils.saveBeforeExperimentRun(event);
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (!(experiment instanceof SysdynGameExperimentBase)) return null;
        final SysdynGameExperimentBase exp = (SysdynGameExperimentBase)experiment;
        try {
            Shell shell;
            SaveHistoryDialog dialog;
            HashMap<DataSet, Pair<String, ImageDescriptor>> map = new HashMap<DataSet, Pair<String, ImageDescriptor>>();
            SysdynResult r = exp.getCurrentResult();
            if (r instanceof MemoryResult) {
                MemoryResult gr = (MemoryResult)r;
                SimulationResult sr = gr.getSimulationResult();
                if (sr == null) {
                    MessageBox messageDialog = new MessageBox(Display.getCurrent().getActiveShell(), 40);
                    messageDialog.setText("No Simulation History");
                    messageDialog.setMessage("There is no simulation history available, please simulate first!");
                    messageDialog.open();
                    return null;
                }
                for (DataSet ds : sr.getVariableDataSets()) {
                    map.put(ds, (Pair<String, ImageDescriptor>)new Pair((Object)ds.name, null));
                }
            }
            if ((dialog = new SaveHistoryDialog(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), map, "Select variables")).open() != 0) return null;
            final Object[] result = dialog.getResult();
            final String sheetName = dialog.getSheetName();
            final String sheetLocation = dialog.getSheetLocation();
            final boolean filterStart = dialog.filterStart();
            final double start = dialog.getStart();
            final boolean filterStep = dialog.filterStep();
            final int step = dialog.getStep();
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void writeCell(WriteGraph graph, Variable sheet, String cellName, String value) throws DatabaseException {
                    SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                    Variable child = sheet.getPossibleChild((ReadGraph)graph, cellName);
                    if (child != null) {
                        child.setPropertyValue(graph, SHEET.Cell_content, (Object)Variant.ofInstance((Object)value), (Binding)Bindings.VARIANT);
                    } else {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        Resource container = sheet.getRepresents((ReadGraph)graph);
                        Resource cell = graph.newResource();
                        graph.claim(cell, L0.InstanceOf, null, SHEET.TextCell);
                        graph.addLiteral(cell, L0.HasName, L0.NameOf, L0.String, (Object)cellName, (Binding)Bindings.STRING);
                        graph.addLiteral(cell, SHEET.Cell_content, SHEET.Cell_content_Inverse, L0.Variant, (Object)Variant.ofInstance((Object)value), (Binding)Bindings.VARIANT);
                        graph.claim(cell, L0.PartOf, container);
                    }
                }

                public void perform(WriteGraph graph) throws DatabaseException {
                    SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                    Resource modelResource = (Resource)graph.syncRequest((Read)new PossibleModel(exp.getResource()));
                    if (modelResource == null) {
                        return;
                    }
                    List sheets = ModelingUtils.searchByTypeAndName((ReadGraph)graph, (Resource)modelResource, (Resource)SHEET.Spreadsheet, (String)sheetName);
                    if (sheets.size() != 1) {
                        return;
                    }
                    Variable sheet = Variables.getVariable((ReadGraph)graph, (Resource)((Resource)sheets.get(0)));
                    Range base = SpreadsheetUtils.decodeCellAbsolute((String)sheetLocation);
                    int row = base.startRow;
                    DataSet first = (DataSet)result[0];
                    this.writeCell(graph, sheet, SpreadsheetUtils.cellName((int)row++, (int)base.startColumn), "time");
                    int i = 0;
                    while (i < first.times.length) {
                        if (!(filterStep && i % step != 0 || filterStart && first.times[i] < start)) {
                            String loc = SpreadsheetUtils.cellName((int)row++, (int)base.startColumn);
                            this.writeCell(graph, sheet, loc, Double.toString(first.times[i]));
                        }
                        ++i;
                    }
                    int j = 0;
                    while (j < result.length) {
                        row = base.startRow;
                        first = (DataSet)result[j];
                        this.writeCell(graph, sheet, SpreadsheetUtils.cellName((int)row++, (int)(base.startColumn + 1 + j)), first.name);
                        int i2 = 0;
                        while (i2 < first.values.length) {
                            if (!(filterStep && i2 % step != 0 || filterStart && first.times[i2] < start)) {
                                String loc = SpreadsheetUtils.cellName((int)row++, (int)(base.startColumn + 1 + j));
                                this.writeCell(graph, sheet, loc, Double.toString(first.values[i2]));
                            }
                            ++i2;
                        }
                        ++j;
                    }
                }
            });
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }
}

