/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.annotation.ui.Activator;
import org.simantics.modelica.data.DataSet;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.ui.workbench.dialogs.ResourceSelectionDialog3;
import org.simantics.utils.datastructures.Pair;

public class SaveHistoryDialog
extends ResourceSelectionDialog3<DataSet> {
    private String sheetName = "";
    private String sheetLocation = "";
    private GridData filterLayout;
    private boolean filterStart = false;
    private boolean startValid = false;
    private double start;
    private boolean filterStep = false;
    private boolean stepValid = false;
    private int step;

    public SaveHistoryDialog(Shell shell, Map<DataSet, Pair<String, ImageDescriptor>> parameter, String title) {
        super(shell, parameter, title);
    }

    protected IDialogSettings getBaseDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected void setSelectionResult(Object[] newResult) {
        super.setSelectionResult(newResult);
        this.validatePage();
    }

    protected Control createExtendedContentArea(final Composite parent_) {
        Composite parent = new Composite(parent_, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)parent);
        Label l = new Label(parent, 0);
        l.setText("Select a sheet:");
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)l);
        final Text t = new Text(parent, 2048);
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveHistoryDialog.this.sheetName = t.getText();
                SaveHistoryDialog.this.validatePage();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)t);
        Label l2 = new Label(parent, 0);
        l2.setText("Select cell in sheet:");
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)l2);
        final Text t2 = new Text(parent, 2048);
        t2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveHistoryDialog.this.sheetLocation = t2.getText();
                SaveHistoryDialog.this.validatePage();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)t2);
        Composite filterControls = new Composite(parent, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)filterControls);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(filterControls);
        Button filterButton = new Button(filterControls, 1028);
        GridDataFactory.fillDefaults().applyTo((Control)filterButton);
        Label filterLabel = new Label(filterControls, 0);
        GridDataFactory.fillDefaults().applyTo((Control)filterLabel);
        filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((SaveHistoryDialog)SaveHistoryDialog.this).filterLayout.exclude = !((SaveHistoryDialog)SaveHistoryDialog.this).filterLayout.exclude;
                parent_.layout();
            }
        });
        filterLabel.setText("show filter options");
        GridDataFactory.fillDefaults().applyTo((Control)filterLabel);
        Composite filterOptions = new Composite(parent, 0);
        this.filterLayout = GridDataFactory.fillDefaults().span(2, 1).grab(true, false).exclude(true).create();
        filterOptions.setLayoutData((Object)this.filterLayout);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(filterOptions);
        final Button startButton = new Button(filterOptions, 32);
        GridDataFactory.fillDefaults().applyTo((Control)startButton);
        startButton.setText("start time (in terms of simulation time)");
        final Text startInput = new Text(filterOptions, 2048);
        GridDataFactory.fillDefaults().applyTo((Control)startInput);
        startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveHistoryDialog.this.filterStart = startButton.getSelection();
                startInput.setEnabled(SaveHistoryDialog.this.filterStart);
                startInput.setBackground(Display.getCurrent().getSystemColor(!SaveHistoryDialog.this.filterStart || SaveHistoryDialog.this.startValid ? 22 : 7));
                SaveHistoryDialog.this.validatePage();
            }
        });
        startInput.setEnabled(false);
        startInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    SaveHistoryDialog.this.start = Double.parseDouble(startInput.getText());
                    SaveHistoryDialog.this.startValid = true;
                }
                catch (Exception ex) {
                    SaveHistoryDialog.this.startValid = false;
                }
                startInput.setBackground(Display.getCurrent().getSystemColor(SaveHistoryDialog.this.startValid ? 22 : 7));
                SaveHistoryDialog.this.validatePage();
            }
        });
        final Button stepButton = new Button(filterOptions, 32);
        GridDataFactory.fillDefaults().applyTo((Control)stepButton);
        stepButton.setText("sample rate (1 = every step, 2 = every other step...)");
        final Text stepInput = new Text(filterOptions, 2048);
        GridDataFactory.fillDefaults().applyTo((Control)stepInput);
        stepButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveHistoryDialog.this.filterStep = stepButton.getSelection();
                stepInput.setEnabled(SaveHistoryDialog.this.filterStep);
                stepInput.setBackground(Display.getCurrent().getSystemColor(!SaveHistoryDialog.this.filterStep || SaveHistoryDialog.this.stepValid ? 22 : 7));
                SaveHistoryDialog.this.validatePage();
            }
        });
        stepInput.setEnabled(false);
        stepInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    SaveHistoryDialog.this.step = Integer.parseInt(stepInput.getText());
                    SaveHistoryDialog.this.stepValid = true;
                }
                catch (Exception ex) {
                    SaveHistoryDialog.this.stepValid = false;
                }
                stepInput.setBackground(Display.getCurrent().getSystemColor(SaveHistoryDialog.this.stepValid ? 22 : 7));
                SaveHistoryDialog.this.validatePage();
            }
        });
        this.validatePage();
        return super.createExtendedContentArea(parent);
    }

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        this.validatePage();
    }

    protected void validatePage() {
        if (this.getSelectedItems().size() == 0) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.ui", "Please select some variable(s)"));
            return;
        }
        String error = this.validateSheet(this.sheetName);
        if (error != null) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.ui", error));
            return;
        }
        error = this.validateLocation(this.sheetLocation);
        if (error != null) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.ui", error));
            return;
        }
        error = this.validateFilter();
        if (error != null) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.ui", error));
            return;
        }
        this.updateStatus((IStatus)new Status(0, "org.simantics.annotation.ui", ""));
    }

    protected String validateSheet(String name) {
        if (name.trim().isEmpty()) {
            return "Sheet name cannot be empty";
        }
        return null;
    }

    protected String validateLocation(String location) {
        block3: {
            try {
                if (!location.isEmpty()) break block3;
                return "Empty location";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        SpreadsheetUtils.decodeCellAbsolute((String)location);
        return null;
    }

    protected String validateFilter() {
        if (this.filterStart && !this.startValid) {
            return "Invalid start time in filter";
        }
        if (this.filterStep && !this.stepValid) {
            return "Invalid sample rate in filter";
        }
        return null;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String getSheetLocation() {
        return this.sheetLocation;
    }

    public boolean filterStart() {
        return this.filterStart;
    }

    public double getStart() {
        return this.start;
    }

    public boolean filterStep() {
        return this.filterStep;
    }

    public int getStep() {
        return this.step;
    }
}

