/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements.connections;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import org.simantics.diagram.elements.TextNode;
import org.simantics.g2d.utils.Alignment;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ISelectionPainterNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.sysdyn.ui.editor.routing.DependencyRouter;
import org.simantics.sysdyn.ui.elements.LoopNode;
import org.simantics.sysdyn.ui.elements.SysdynElementHints;
import org.simantics.sysdyn.ui.elements.connections.Arcs;
import org.simantics.sysdyn.ui.utils.SysdynWorkbenchUtils;
import org.simantics.utils.datastructures.Triple;

public class DependencyNode
extends TextNode
implements ISelectionPainterNode,
LoopNode.ILoopComponentNode {
    public static final String INSIDE = "Inside";
    public static final String OUTSIDE = "Outside";
    public static final double HITMARGIN = 1.7;
    private static final long serialVersionUID = 1294351381209071074L;
    private Color color;
    private Stroke stroke;
    private Shape beginBounds;
    private Shape endBounds;
    private double angle = 0.3;
    private String side;
    private boolean delayMark = false;
    private boolean arrowHead = true;
    private transient Triple<Arc2D, Path2D, Path2D> shapes = new Triple((Object)new Arc2D.Double(), (Object)new Path2D.Double(), (Object)new Path2D.Double());
    public transient boolean hover = false;
    private boolean dragging = false;
    private transient PropertyChangeListener fieldListener = null;
    boolean pressHit = false;
    private HashMap<LoopNode, Boolean> loopSelectionMap = new HashMap();

    public void init() {
        super.init();
        this.addEventHandler((IEventHandler)this);
    }

    public void init(String text, String side, boolean delayMark, boolean arrowHead, Font font, Color color, double x, double y, double scale) {
        super.init(text, font, color, x, y, scale);
        this.side = side;
        this.delayMark = delayMark;
        this.arrowHead = arrowHead;
        this.setHorizontalAlignment((byte)Alignment.CENTER.ordinal());
        this.setVerticalAlignment((byte)Alignment.CENTER.ordinal());
    }

    public void cleanup() {
        super.cleanup();
    }

    public void setFieldListener(PropertyChangeListener listener) {
        this.fieldListener = listener;
    }

    @INode.ServerSide
    public void commitProperty(String field, Object value) {
        if (this.fieldListener != null) {
            this.fieldListener.propertyChange(new PropertyChangeEvent(this, field, null, value));
        }
    }

    @INode.PropertySetter(value="color")
    @INode.SyncField(value={"color"})
    public void setColor(Color color) {
        this.color = color;
    }

    @INode.PropertySetter(value="stroke")
    @INode.SyncField(value={"stroke"})
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @INode.PropertySetter(value="beginBounds")
    @INode.SyncField(value={"beginBounds"})
    public void setBeginBounds(Shape beginBounds) {
        this.beginBounds = beginBounds;
    }

    @INode.PropertySetter(value="endBounds")
    @INode.SyncField(value={"endBounds"})
    public void setEndBounds(Shape endBounds) {
        this.endBounds = endBounds;
    }

    @INode.PropertySetter(value="angle")
    @INode.SyncField(value={"angle"})
    public void setAngle(Double angle) {
        this.angle = angle;
        if (this.beginBounds != null && this.endBounds != null) {
            this.shapes = DependencyRouter.createArrowShape(this.shapes, this.beginBounds, this.endBounds, this.angle, this.stroke);
        }
    }

    @INode.PropertySetter(value="shapes")
    @INode.SyncField(value={"shapes"})
    public void setShapes(Triple<Arc2D, Path2D, Path2D> shapes) {
        this.shapes = shapes;
    }

    public Color getColor() {
        return this.color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public Shape getBeginBounds() {
        return this.beginBounds;
    }

    public Shape getEndBounds() {
        return this.endBounds;
    }

    public double getAngle() {
        return this.angle;
    }

    public Triple<Arc2D, Path2D, Path2D> getShapes() {
        return this.shapes;
    }

    public void render(Graphics2D g) {
        float strokeWidth;
        if (this.beginBounds == null || this.endBounds == null) {
            return;
        }
        boolean selected = NodeUtil.isSelected((INode)this, (int)2);
        if (this.font != null) {
            g.setFont(this.font);
        }
        if (selected) {
            g.setColor(Color.PINK);
            strokeWidth = 1.4f + 2.0f * (this.stroke instanceof BasicStroke ? ((BasicStroke)this.stroke).getLineWidth() : 0.3f);
            g.setStroke(new BasicStroke(strokeWidth));
            g.draw((Shape)this.shapes.first);
            g.fill((Shape)this.shapes.second);
            if (this.color != null) {
                g.setColor(this.color);
            }
            g.setStroke(this.stroke);
            g.draw((Shape)this.shapes.first);
            if (this.arrowHead) {
                g.draw((Shape)this.shapes.second);
                g.fill((Shape)this.shapes.second);
            }
            if (this.delayMark) {
                g.draw((Shape)this.shapes.third);
            }
        } else if (this.hover) {
            g.setColor(Color.LIGHT_GRAY);
            strokeWidth = 1.4f + 2.0f * (this.stroke instanceof BasicStroke ? ((BasicStroke)this.stroke).getLineWidth() : 0.3f);
            g.setStroke(new BasicStroke(strokeWidth));
            g.draw((Shape)this.shapes.first);
            g.fill((Shape)this.shapes.second);
            if (this.color != null) {
                g.setColor(this.color);
            }
            g.setStroke(this.stroke);
            g.draw((Shape)this.shapes.first);
            if (this.arrowHead) {
                g.draw((Shape)this.shapes.second);
                g.fill((Shape)this.shapes.second);
            }
            if (this.delayMark) {
                g.draw((Shape)this.shapes.third);
            }
        } else if (this.isLoopSelected()) {
            g.setColor(LoopNode.HIGHLIGHT_COLOR);
            if (this.stroke != null) {
                g.setStroke(this.stroke);
            }
            g.draw((Shape)this.shapes.first);
            if (this.arrowHead) {
                g.draw((Shape)this.shapes.second);
                g.fill((Shape)this.shapes.second);
            }
            if (this.delayMark) {
                g.draw((Shape)this.shapes.third);
            }
        } else {
            if (this.color != null) {
                g.setColor(this.color);
            }
            if (this.stroke != null) {
                g.setStroke(this.stroke);
            }
            g.draw((Shape)this.shapes.first);
            if (this.arrowHead) {
                g.draw((Shape)this.shapes.second);
                g.fill((Shape)this.shapes.second);
            }
            if (this.delayMark) {
                g.draw((Shape)this.shapes.third);
            }
        }
        double angleRad = this.angle > 0.0 ? Math.toRadians(((Arc2D)this.shapes.first).getAngleStart() + ((Arc2D)this.shapes.first).getAngleExtent()) : Math.toRadians(((Arc2D)this.shapes.first).getAngleStart());
        Point2D point = this.angle > 0.0 ? ((Arc2D)this.shapes.first).getEndPoint() : ((Arc2D)this.shapes.first).getStartPoint();
        int angle1 = 220;
        int angle2 = -40;
        if (OUTSIDE.equals(this.side)) {
            angle1 *= -1;
            angle2 *= -1;
        }
        double a = Math.toRadians(this.angle < 0.0 ? angle1 : angle2);
        double s = Math.sin(a) * 3.0;
        double c = Math.cos(a) * 4.0;
        g.translate(point.getX(), point.getY());
        g.rotate(-angleRad);
        g.translate(s, c);
        g.rotate(angleRad);
        super.render(g);
        g.rotate(-angleRad);
        g.translate(-s, -c);
        g.rotate(angleRad);
        g.translate(-point.getX(), -point.getY());
    }

    private boolean isLoopSelected() {
        return this.loopSelectionMap.containsValue(true);
    }

    protected boolean hitTest(MouseEvent event, double tolerance) {
        if (this.beginBounds == null || this.endBounds == null) {
            return false;
        }
        Point2D localPos = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)event.controlPosition, (Point2D)new Point2D.Double());
        return Arcs.hitTest(this.beginBounds, this.endBounds, this.angle, localPos.getX(), localPos.getY(), tolerance);
    }

    protected double getRadialDistanse(Point2D coord) {
        if (this.beginBounds == null || this.endBounds == null) {
            return Double.NaN;
        }
        Point2D localPos = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)coord, (Point2D)new Point2D.Double());
        return Arcs.getRadialDistance(this.beginBounds, this.endBounds, this.angle, localPos.getX(), localPos.getY());
    }

    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    public int getEventMask() {
        return super.getEventMask() | EventTypes.MouseDragBeginMask | EventTypes.MouseButtonPressedMask | EventTypes.MouseButtonReleasedMask;
    }

    protected boolean mouseMoved(MouseEvent.MouseMovedEvent event) {
        boolean hit = this.hitTest((MouseEvent)event, 1.7);
        if (this.dragging) {
            Point2D localPos = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)event.controlPosition, (Point2D)new Point2D.Double());
            this.setAngle(Arcs.angleOfArc(this.beginBounds.getBounds2D().getCenterX(), this.beginBounds.getBounds2D().getCenterY(), localPos.getX(), localPos.getY(), this.endBounds.getBounds2D().getCenterX(), this.endBounds.getBounds2D().getCenterY()));
            this.repaint();
        }
        if (hit != this.hover) {
            this.hover = hit;
            this.repaint();
        }
        return false;
    }

    private static boolean isEventDummy(MouseEvent.MouseDragBegin e) {
        return e.controlPosition.distance(0.0, 0.0) == 0.0 && e.screenPosition.distance(0.0, 0.0) == 0.0 && e.buttons == 0;
    }

    protected boolean mouseDragged(MouseEvent.MouseDragBegin e) {
        if (DependencyNode.isEventDummy(e)) {
            return false;
        }
        if (SysdynElementHints.LOCK_TOOL.equals(SysdynWorkbenchUtils.getSysdynToolMode())) {
            return false;
        }
        boolean selected = NodeUtil.isSelected((INode)this, (int)2);
        double myRadialDistance = this.getRadialDistanse(e.controlPosition);
        Collection nodes = this.getParent().getParent().getParent().getNodes();
        if (!selected) {
            for (Object temp1 : nodes) {
                if (!(temp1 instanceof ConnectionNode)) continue;
                for (IG2DNode temp2 : ((ConnectionNode)temp1).getNodes()) {
                    if (!(temp2 instanceof SingleElementNode)) continue;
                    for (IG2DNode temp3 : ((SingleElementNode)temp2).getNodes()) {
                        double otherNodeDist;
                        DependencyNode otherDependencyNode;
                        if (!(temp3 instanceof DependencyNode) || (otherDependencyNode = (DependencyNode)temp3) == this || Double.isNaN(otherNodeDist = otherDependencyNode.getRadialDistanse(e.controlPosition))) continue;
                        if (otherDependencyNode.isDragging()) {
                            return true;
                        }
                        if (NodeUtil.isSelected((INode)otherDependencyNode, (int)2) && otherNodeDist < 1.7) {
                            return false;
                        }
                        if (!(otherNodeDist < myRadialDistance)) continue;
                        return false;
                    }
                }
            }
        }
        if (myRadialDistance < 1.7 && !this.dragging) {
            this.dragging = true;
            return true;
        }
        return false;
    }

    protected boolean mouseButtonPressed(MouseEvent.MouseButtonPressedEvent e) {
        return false;
    }

    protected boolean mouseButtonReleased(MouseEvent.MouseButtonReleasedEvent e) {
        if (this.dragging) {
            this.commitProperty("angle", this.angle);
            this.dragging = false;
        }
        return false;
    }

    protected boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void setLoopSelected(LoopNode loop, boolean selected) {
        Boolean loopSelected = this.loopSelectionMap.get((Object)loop);
        if (loopSelected == null || loopSelected != selected) {
            this.loopSelectionMap.put(loop, selected);
            this.repaint();
        }
    }
}

