/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.elements.ResizeNode;
import org.simantics.diagram.elements.ResizeRectangularSceneGraph;
import org.simantics.diagram.elements.TextElementNoBounds;
import org.simantics.diagram.elements.TextNode;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.HoverImpl;
import org.simantics.g2d.element.handler.impl.ObjectTerminal;
import org.simantics.g2d.element.handler.impl.OutlinePick;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.handler.impl.StaticSymbolImageInitializer;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.TextColorImpl;
import org.simantics.g2d.element.handler.impl.TextFontImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ShapeImage;
import org.simantics.g2d.utils.Alignment;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.elements.HoverShapeNode;
import org.simantics.sysdyn.ui.elements.Orientation;
import org.simantics.sysdyn.ui.elements.SysdynElementFactory;
import org.simantics.sysdyn.ui.elements.SysdynElementHints;
import org.simantics.sysdyn.ui.elements.SysdynElementUtils;
import org.simantics.sysdyn.ui.elements.SysdynTextElementNoBounds;
import org.simantics.sysdyn.ui.elements.ValveOutline;
import org.simantics.sysdyn.ui.elements.ValveTextLocation;
import org.simantics.sysdyn.ui.elements.WholeElementTerminals;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class ValveFactory
extends SysdynElementFactory {
    public static final IHintContext.Key KEY_ROTATED = new IHintContext.KeyOf(Boolean.class, "ROTATED");
    public static final double VALVE_SIZE = 1.5;
    private static final BasicStroke STROKE = new BasicStroke(1.0f);
    public static final Image VALVE_STATIC_IMAGE = new ShapeImage((Shape)ValveFactory.createShape(1.5, false), null, (Stroke)STROKE, true);

    @Override
    protected ElementClass compileElementClass(Resource elementType, Collection<ObjectTerminal> terminals) {
        return ElementClass.compile((ElementHandler[])new ElementHandler[]{SimpleElementLayers.INSTANCE, OutlinePick.INSTANCE, TextImpl.INSTANCE, TextColorImpl.BLACK, TextFontImpl.DEFAULT, DefaultTransform.INSTANCE, new StaticObjectAdapter((Object)elementType), new StaticSymbolImpl(VALVE_STATIC_IMAGE), StaticSymbolImageInitializer.INSTANCE, HoverImpl.INSTANCE, Orientation.INSTANCE, ValveTextLocation.INSTANCE, ValveSceneGraph.INSTANCE, ValveText.INSTANCE, new ResizeRectangularSceneGraph(TextElementNoBounds.SG_NODE), RESIZE_PROPERTY_SETTER, ValveBounds.INSTANCE, ValveOutline.INSTANCE, new WholeElementTerminals(terminals)}).setId(ValveFactory.class.getSimpleName());
    }

    @Override
    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource element, IElement e) throws DatabaseException {
        super.load(graph, canvas, diagram, element, e);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Resource orientation = graph.getPossibleObject(element, sr.ValveSymbol_orientation);
        String orientationText = orientation != null && sr.Vertical.equals(orientation) ? "Vertical" : "Horizontal";
        SysdynElementUtils.setOrientation(e, orientationText);
        Resource location = graph.getPossibleObject(element, sr.ValveSymbol_textLocation);
        String locationText = location == null || sr.Bottom.equals(location) ? "Bottom" : (sr.Top.equals(location) ? "Top" : (sr.Left.equals(location) ? "Left" : "Right"));
        SysdynElementUtils.setValveTextLocation(e, locationText);
        ResizeRectangularSceneGraph resize = (ResizeRectangularSceneGraph)e.getElementClass().getSingleItem(ResizeRectangularSceneGraph.class);
        if (resize != null) {
            if (location == null || sr.Bottom.equals(location)) {
                resize.setYTranslateEdge(ResizeNode.TranslateEdge.NORTH);
                resize.setXTranslateEdge(ResizeNode.TranslateEdge.NONE);
            } else if (sr.Top.equals(location)) {
                resize.setYTranslateEdge(ResizeNode.TranslateEdge.SOUTH);
                resize.setXTranslateEdge(ResizeNode.TranslateEdge.NONE);
            } else if (sr.Left.equals(location)) {
                resize.setYTranslateEdge(ResizeNode.TranslateEdge.NONE);
                resize.setXTranslateEdge(ResizeNode.TranslateEdge.EAST);
            } else {
                resize.setYTranslateEdge(ResizeNode.TranslateEdge.NONE);
                resize.setXTranslateEdge(ResizeNode.TranslateEdge.WEST);
            }
        }
    }

    private static Path2D createShape(double valveSize, boolean rotated) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(-valveSize, -valveSize);
        if (rotated) {
            ((Path2D)path).lineTo(-valveSize, valveSize);
            ((Path2D)path).lineTo(valveSize, -valveSize);
        } else {
            ((Path2D)path).lineTo(valveSize, -valveSize);
            ((Path2D)path).lineTo(-valveSize, valveSize);
        }
        ((Path2D)path).lineTo(valveSize, valveSize);
        path.closePath();
        return path;
    }

    public static class ValveBounds
    implements InternalSize {
        private static final long serialVersionUID = -666692270776359301L;
        public static final ValveBounds INSTANCE = new ValveBounds();

        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            TextNode textNode = (TextNode)e.getHint(TextElementNoBounds.SG_NODE);
            ValveSceneGraph valveSG = (ValveSceneGraph)e.getElementClass().getSingleItem(ValveSceneGraph.class);
            if (textNode != null && valveSG != null) {
                try {
                    AffineTransform elementTransform = ElementUtils.getTransform((IElement)e);
                    AffineTransform nodeTransform = textNode.getTransform();
                    AffineTransform elementTransformInverse = elementTransform.createInverse();
                    elementTransformInverse.concatenate(nodeTransform);
                    Rectangle2D text = textNode.getBoundsInLocal();
                    Shape textShape = elementTransformInverse.createTransformedShape(text);
                    Rectangle2D valve = valveSG.getValveBounds(e, new Rectangle2D.Double());
                    size.setRect(textShape.getBounds2D());
                    size.add(valve);
                    return size;
                }
                catch (NoninvertibleTransformException e1) {
                    e1.printStackTrace();
                }
            }
            Path2D path = ValveFactory.createShape(1.5, Boolean.TRUE.equals(e.getHint(KEY_ROTATED)));
            return path.getBounds2D();
        }
    }

    public static class ValveSceneGraph
    implements SceneGraph {
        private static final long serialVersionUID = 7987939328158347639L;
        public static final ValveSceneGraph INSTANCE = new ValveSceneGraph();
        private static final IHintContext.Key VALVE_SG_NODE = new SceneGraphNodeKey(ShapeNode.class, "VALVE_SHAPE_NODE");
        private IHintListener hoverHintListener;

        public void init(IElement e, G2DParentNode parent) {
            HoverShapeNode node = (HoverShapeNode)ElementUtils.getOrCreateNode((IElement)e, (ParentNode)parent, (IHintContext.Key)VALVE_SG_NODE, (String)"valveShape", HoverShapeNode.class);
            node.setStroke(STROKE);
            node.setScaleStroke(true);
            Color color = (Color)e.getHint(ElementHints.KEY_TEXT_COLOR);
            node.setColor(color != null ? color : Color.BLACK);
            boolean rotated = false;
            String orientation = SysdynElementUtils.getOrientation(e);
            if (orientation != null && orientation.equals("Vertical")) {
                rotated = true;
            }
            node.setShape(ValveFactory.createShape(1.5, Boolean.TRUE.equals(rotated)));
            Boolean hover = (Boolean)e.getHint(ElementHints.KEY_HOVER);
            node.setHover(hover != null ? hover : false);
            AffineTransform at = ElementUtils.getTransform((IElement)e);
            if (at != null) {
                node.setTransform(at);
            }
            this.hoverHintListener = new IHintListener(){

                public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
                }

                public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                    IElement e = (IElement)sender;
                    HoverShapeNode shape = (HoverShapeNode)((Object)e.getHint(VALVE_SG_NODE));
                    if (shape == null) {
                        return;
                    }
                    boolean hover = ElementUtils.isHovering((IElement)e);
                    shape.setHover(hover);
                }
            };
            e.addHintListener(this.hoverHintListener);
        }

        public void cleanup(IElement e) {
            e.removeHintListener(this.hoverHintListener);
            ElementUtils.removePossibleNode((IElement)e, (IHintContext.Key)VALVE_SG_NODE);
        }

        public Rectangle2D getValveBounds(IElement e, Rectangle2D size) {
            HoverShapeNode node;
            if (size == null) {
                size = new Rectangle2D.Double();
            }
            if ((node = (HoverShapeNode)((Object)e.getHint(VALVE_SG_NODE))) != null) {
                size.setFrame(node.getBoundsInLocal());
            } else {
                size.setFrame(ValveFactory.createShape(1.5, Boolean.TRUE.equals(e.getHint(KEY_ROTATED))).getBounds2D());
            }
            double padding = 1.0;
            size.setFrame(size.getX() - padding, size.getY() - padding, size.getWidth() + padding * 2.0, size.getHeight() + padding * 2.0);
            return size;
        }
    }

    public static class ValveText
    extends SysdynTextElementNoBounds {
        private static final long serialVersionUID = -5354779831383095960L;
        public static ValveText INSTANCE = new ValveText();

        public ValveText() {
            super(0.0, 0.0, Alignment.CENTER, 0.0, 1.0, 1.0, true);
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            super.init(e, parent);
            TextNode text = (TextNode)e.getHint(TextElementNoBounds.SG_NODE);
            HoverShapeNode valve = (HoverShapeNode)((Object)e.getHint(ValveSceneGraph.VALVE_SG_NODE));
            if (valve != null && text != null) {
                Rectangle2D textBounds = text.getBoundsInLocal();
                Rectangle2D valveBounds = valve.getBoundsInLocal();
                AffineTransform at = (AffineTransform)text.getTransform().clone();
                at.translate(ValveText.getTextXTranslate(e, textBounds, valveBounds), ValveText.getTextYTranslate(e, textBounds, valveBounds));
                text.setTransform(at);
            }
        }

        private static double getTextXTranslate(IElement e, Rectangle2D textBounds, Rectangle2D valveBounds) {
            String location = (String)e.getHint(SysdynElementHints.KEY_LOCATION);
            if (location.equals("Bottom")) {
                return -textBounds.getCenterX();
            }
            if (location.equals("Top")) {
                return -textBounds.getCenterX();
            }
            if (location.equals("Left")) {
                return -textBounds.getMaxX() - valveBounds.getWidth() / 2.0;
            }
            return valveBounds.getMaxX() - textBounds.getMinX();
        }

        private static double getTextYTranslate(IElement e, Rectangle2D textBounds, Rectangle2D valveBounds) {
            String location = (String)e.getHint(SysdynElementHints.KEY_LOCATION);
            if (location.equals("Bottom")) {
                return valveBounds.getMaxY() - textBounds.getMinY();
            }
            if (location.equals("Top")) {
                return valveBounds.getMinY() - textBounds.getMaxY();
            }
            if (location.equals("Left")) {
                return -textBounds.getCenterY();
            }
            return -textBounds.getCenterY();
        }
    }
}

