/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor.routing;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.simantics.g2d.routing.Constants;
import org.simantics.g2d.routing.IConnection;
import org.simantics.g2d.routing.IRouter2;
import org.simantics.sysdyn.ui.editor.routing.SysdynLocalRouter;
import org.simantics.sysdyn.ui.elements.connections.Flows;

public class FlowRouter
implements IRouter2 {
    SysdynLocalRouter localRouter = new SysdynLocalRouter();
    public static final float OFFSET = 0.5f;
    static final AffineTransform IDENTITY = new AffineTransform();

    public FlowRouter() {
        this(false);
    }

    public FlowRouter(boolean roundCorners) {
    }

    private Path2D route(double beginX, double beginY, int sDir, Rectangle2D beginObstacle, double endX, double endY, int tDir, Rectangle2D endObstacle) {
        this.localRouter.sx = beginX;
        this.localRouter.sy = beginY;
        if (beginObstacle == null) {
            this.localRouter.aMinX = beginX;
            this.localRouter.aMinY = beginY;
            this.localRouter.aMaxX = beginX;
            this.localRouter.aMaxY = beginY;
        } else {
            this.localRouter.aMinX = beginObstacle.getMinX();
            this.localRouter.aMinY = beginObstacle.getMinY();
            this.localRouter.aMaxX = beginObstacle.getMaxX();
            this.localRouter.aMaxY = beginObstacle.getMaxY();
        }
        this.localRouter.sourceDirection = sDir;
        this.localRouter.tx = endX;
        this.localRouter.ty = endY;
        if (endObstacle == null) {
            this.localRouter.bMinX = endX;
            this.localRouter.bMinY = endY;
            this.localRouter.bMaxX = endX;
            this.localRouter.bMaxY = endY;
        } else {
            this.localRouter.bMinX = endObstacle.getMinX();
            this.localRouter.bMinY = endObstacle.getMinY();
            this.localRouter.bMaxX = endObstacle.getMaxX();
            this.localRouter.bMaxY = endObstacle.getMaxY();
        }
        this.localRouter.targetDirection = tDir;
        if (sDir == 0 || sDir == 2) {
            this.localRouter.aMinY += 0.5;
            this.localRouter.aMaxY -= 0.5;
        }
        if (tDir == 0 || tDir == 2) {
            this.localRouter.bMinY += 0.5;
            this.localRouter.bMaxY -= 0.5;
        }
        if (sDir == 1 || sDir == 3) {
            this.localRouter.aMinX += 0.5;
            this.localRouter.aMaxX -= 0.5;
        }
        if (tDir == 1 || tDir == 3) {
            this.localRouter.bMinX += 0.5;
            this.localRouter.bMaxX -= 0.5;
        }
        this.localRouter.route();
        Path2D completePath = new Path2D.Double();
        completePath = Flows.createOffsetPath(this.localRouter.path, 0.5f);
        completePath.append(Flows.createOffsetPath(this.localRouter.path, -0.5f), false);
        return completePath;
    }

    public void route(IConnection connection) {
        Collection segments = connection.getSegments();
        if (segments.size() == 1) {
            for (Object seg : segments) {
                IConnection.Connector begin = connection.getBegin(seg);
                IConnection.Connector end = connection.getEnd(seg);
                double bestLength = Double.POSITIVE_INFINITY;
                Path2D bestPath = null;
                int[] nArray = Constants.POSSIBLE_DIRECTIONS[begin.allowedDirections];
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int sDir = nArray[n2];
                    int[] nArray2 = Constants.POSSIBLE_DIRECTIONS[end.allowedDirections];
                    int n3 = nArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int tDir = nArray2[n4];
                        Path2D path = this.route(begin.x, begin.y, sDir, begin.parentObstacle, end.x, end.y, tDir, end.parentObstacle);
                        double length = FlowRouter.pathCost(path);
                        if (length < bestLength) {
                            bestLength = length;
                            bestPath = path;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                if (bestPath == null) continue;
                connection.setPath(seg, bestPath);
            }
        }
    }

    static double pathCost(Path2D path) {
        double length = 0.0;
        PathIterator it = path.getPathIterator(IDENTITY);
        double[] temp = new double[6];
        double x = 0.0;
        double y = 0.0;
        double bendCount = 0.0;
        while (!it.isDone()) {
            bendCount += 1.0;
            if (it.currentSegment(temp) != 0) {
                length += Math.abs(x - temp[0] + y - temp[1]);
            }
            x = temp[0];
            y = temp[1];
            it.next();
        }
        return bendCount - 1.0 / length;
    }
}

