/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor.routing;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.routing.IConnection;
import org.simantics.g2d.routing.IRouter2;
import org.simantics.sysdyn.ui.elements.connections.Arcs;
import org.simantics.utils.datastructures.Triple;

public class DependencyRouter
implements IRouter2 {
    public static DependencyRouter INSTANCE = new DependencyRouter();
    public static double ARROW_LENGTH1 = 0.1;
    public static double ARROW_LENGTH2 = 1.9;
    public static double ARROW_WIDTH = 0.7;
    public static double DELAYMARK_LENGTH = 6.0;
    public static double DELAYMARK_GAP = 0.4;

    public void route(IConnection connection) {
        if (connection.getSegments().isEmpty()) {
            return;
        }
        Object seg = connection.getSegments().iterator().next();
        IConnection.Connector begin = connection.getBegin(seg);
        IConnection.Connector end = connection.getEnd(seg);
        Triple shapes = new Triple((Object)new Arc2D.Double(), (Object)new Path2D.Double(), (Object)new Path2D.Double());
        DependencyRouter.createArrowShape((Triple<Arc2D, Path2D, Path2D>)shapes, begin.parentObstacle, end.parentObstacle, 0.3, null);
        Path2D.Double path = new Path2D.Double();
        path.append((Shape)shapes.first, false);
        path.append((Shape)shapes.second, false);
        connection.setPath(seg, (Path2D)path);
    }

    private static Path2D createArrow(Path2D shape, double x, double y, double dx, double dy) {
        if (shape == null) {
            shape = new Path2D.Double();
        } else {
            shape.reset();
        }
        shape.moveTo(x + ARROW_LENGTH1 * dx, y + ARROW_LENGTH1 * dy);
        shape.lineTo((x -= ARROW_LENGTH2 * dx) - ARROW_WIDTH * dy, (y -= ARROW_LENGTH2 * dy) + ARROW_WIDTH * dx);
        shape.lineTo(x + ARROW_WIDTH * dy, y - ARROW_WIDTH * dx);
        shape.closePath();
        return shape;
    }

    public static Arc2D createArc(Arc2D arc, Shape beginBounds, Shape endBounds, double angle) {
        if (beginBounds == null || endBounds == null) {
            return new Arc2D.Double();
        }
        double x0 = beginBounds.getBounds2D().getCenterX();
        double y0 = beginBounds.getBounds2D().getCenterY();
        double x1 = endBounds.getBounds2D().getCenterX();
        double y1 = endBounds.getBounds2D().getCenterY();
        double offset = Math.abs(angle) < 1.0E-6 ? 1000.0 * Math.signum(angle) : Math.tan(1.5707963267948966 - angle) * 0.5;
        double cx = 0.5 * (x0 + x1) + offset * (y1 - y0);
        double cy = 0.5 * (y0 + y1) + offset * (x0 - x1);
        double dx0 = x0 - cx;
        double dy0 = y0 - cy;
        double dx1 = x1 - cx;
        double dy1 = y1 - cy;
        double r = Math.sqrt(dx0 * dx0 + dy0 * dy0);
        double angle0 = Arcs.nextIntersectingAngle(cx, cy, r, Math.atan2(-dy0, dx0), beginBounds, angle < 0.0);
        double angle1 = Arcs.nextIntersectingAngle(cx, cy, r, Math.atan2(-dy1, dx1), endBounds, angle > 0.0);
        double extent = angle1 - angle0;
        if (angle < 0.0) {
            double temp = angle0;
            angle0 = angle1;
            angle1 = temp;
            extent = -extent;
        }
        if (extent < 0.0) {
            extent += Math.PI * 2;
        } else if (extent >= 360.0) {
            extent -= Math.PI * 2;
        }
        if (arc == null) {
            arc = new Arc2D.Double();
        }
        arc.setArc(cx - r, cy - r, 2.0 * r, 2.0 * r, Math.toDegrees(angle0), Math.toDegrees(extent), 0);
        return arc;
    }

    public static Point2D computeCenter(Rectangle2D tail, Rectangle2D head, double angle) {
        double x0 = tail.getCenterX();
        double y0 = tail.getCenterY();
        double x1 = head.getCenterX();
        double y1 = head.getCenterY();
        double offset = Math.abs(angle) < 1.0E-6 ? 1000.0 * Math.signum(angle) : Math.tan(1.5707963267948966 - angle) * 0.5;
        double cx = 0.5 * (x0 + x1) + offset * (y1 - y0);
        double cy = 0.5 * (y0 + y1) + offset * (x0 - x1);
        return new Point2D.Double(cx, cy);
    }

    public static Path2D createDelayMark(Path2D shape, double x, double y, double angle, BasicStroke stroke) {
        if (shape == null) {
            shape = new Path2D.Double();
        } else {
            shape.reset();
        }
        float strokeWidth = stroke != null ? stroke.getLineWidth() : 0.3f;
        double dx = Math.cos(angle) * (DELAYMARK_LENGTH + (double)strokeWidth) / 2.0;
        double dy = -Math.sin(angle) * (DELAYMARK_LENGTH + (double)strokeWidth) / 2.0;
        double dxGap = Math.cos(angle + 1.5707963267948966) * (DELAYMARK_GAP / 2.0 + (double)strokeWidth);
        double dyGap = -Math.sin(angle + 1.5707963267948966) * (DELAYMARK_GAP / 2.0 + (double)strokeWidth);
        shape.moveTo(x - dx - dxGap, y - dy - dyGap);
        shape.lineTo(x + dx - dxGap, y + dy - dyGap);
        shape.moveTo(x - dx + dxGap, y - dy + dyGap);
        shape.lineTo(x + dx + dxGap, y + dy + dyGap);
        return shape;
    }

    public static Triple<Arc2D, Path2D, Path2D> createArrowShape(Triple<Arc2D, Path2D, Path2D> shapes, Shape beginBounds, Shape endBounds, double angle, Stroke stroke) {
        if (shapes == null || shapes.first == null || shapes.second == null || shapes.third == null) {
            shapes = new Triple((Object)new Arc2D.Double(), (Object)new Path2D.Double(), (Object)new Path2D.Double());
        }
        DependencyRouter.createArc((Arc2D)shapes.first, beginBounds, endBounds, angle);
        double angle0 = Math.toRadians(((Arc2D)shapes.first).getAngleStart());
        double angle1 = Math.toRadians(((Arc2D)shapes.first).getAngleStart() + ((Arc2D)shapes.first).getAngleExtent());
        double x = Math.cos(angle > 0.0 ? angle1 : angle0);
        double y = -Math.sin(angle > 0.0 ? angle1 : angle0);
        double r = ((Arc2D)shapes.first).getHeight() / 2.0;
        DependencyRouter.createArrow((Path2D)shapes.second, ((Arc2D)shapes.first).getCenterX() + r * x, ((Arc2D)shapes.first).getCenterY() + r * y, angle < 0.0 ? -y : y, angle > 0.0 ? -x : x);
        double angleCenter = Math.toRadians(((Arc2D)shapes.first).getAngleStart() + ((Arc2D)shapes.first).getAngleExtent() / 2.0);
        double arcCenterX = ((Arc2D)shapes.first).getCenterX() + r * Math.cos(angleCenter);
        double arcCenterY = ((Arc2D)shapes.first).getCenterY() - r * Math.sin(angleCenter);
        DependencyRouter.createDelayMark((Path2D)shapes.third, arcCenterX, arcCenterY, angleCenter, stroke instanceof BasicStroke ? (BasicStroke)stroke : null);
        return shapes;
    }
}

