/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor.participant;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.canvas.IToolMode;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.connection.IConnectionAdvisor;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.TerminalPainter;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.sysdyn.ui.editor.participant.SysdynConnectTool;
import org.simantics.sysdyn.ui.editor.participant.SysdynElementClassProviders;
import org.simantics.sysdyn.ui.editor.routing.DependencyRouter;
import org.simantics.sysdyn.ui.editor.routing.FlowRouter;
import org.simantics.sysdyn.ui.elements.AuxiliaryFactory;
import org.simantics.sysdyn.ui.elements.CloudFactory;
import org.simantics.sysdyn.ui.elements.InputFactory;
import org.simantics.sysdyn.ui.elements.ModuleFactory;
import org.simantics.sysdyn.ui.elements.SysdynElementHints;
import org.simantics.sysdyn.ui.elements.connections.ConnectionClasses;

public class SysdynPointerInteractor
extends PointerInteractor {
    @DependencyReflection.Dependency
    Selection selection;
    @DependencyReflection.Dependency
    KeyUtil keys;
    @DependencyReflection.Dependency
    TransformUtil util;
    @DependencyReflection.Dependency
    PickContext pickContext;
    @DependencyReflection.Dependency
    MouseUtil mice;
    @DependencyReflection.Reference
    TerminalPainter terminalPainter;

    public SysdynPointerInteractor(boolean clickSelect, boolean boxSelect, boolean dragElement, boolean dndDragElement, boolean connect, boolean doubleClickEdit, IElementClassProvider newConnectionClassProvider, PickRequest.PickSorter pickSorter) {
        super(clickSelect, boxSelect, dragElement, dndDragElement, connect, doubleClickEdit, newConnectionClassProvider, pickSorter);
    }

    @EventHandlerReflection.EventHandler(priority=0x200000)
    public boolean handlePress(MouseEvent.MouseButtonPressedEvent me) {
        if (!this.connects()) {
            return false;
        }
        if (this.elementClassProvider == null) {
            return false;
        }
        if (this.getContext().containsItemByClass(SysdynConnectTool.class)) {
            return false;
        }
        IToolMode mode = (IToolMode)this.getHint(Hints.KEY_TOOL);
        if (!Hints.CONNECTTOOL.equals(mode)) {
            return false;
        }
        IToolMode sysdynMode = (IToolMode)this.getHint(SysdynElementHints.SYSDYN_KEY_TOOL);
        this.assertDependencies();
        TerminalUtil.TerminalInfo ti = this.pickTerminal(me.controlPosition);
        Point2D curCanvasPos = this.util.controlToCanvas(me.controlPosition, null);
        ICanvasParticipant bsi = null;
        if (me.button == 1) {
            if (SysdynElementHints.LOCK_TOOL.equals(sysdynMode)) {
                return false;
            }
            bsi = SysdynElementHints.DEPENDENCY_TOOL.equals(sysdynMode) ? this.getDependencyConnectTool(ti, me.mouseId, curCanvasPos) : (SysdynElementHints.FLOW_TOOL.equals(sysdynMode) ? this.getFlowConnectTool(ti, me.mouseId, curCanvasPos) : this.getDependencyConnectTool(ti, me.mouseId, curCanvasPos));
        } else if (me.button == 2) {
            if (SysdynElementHints.LOCK_TOOL.equals(sysdynMode) || SysdynElementHints.DEPENDENCY_TOOL.equals(sysdynMode) || SysdynElementHints.FLOW_TOOL.equals(sysdynMode)) {
                return false;
            }
            bsi = this.getFlowConnectTool(ti, me.mouseId, curCanvasPos);
        }
        if (bsi != null) {
            this.getContext().add(bsi);
            return true;
        }
        return false;
    }

    private ICanvasParticipant getDependencyConnectTool(TerminalUtil.TerminalInfo ti, int mouseId, Point2D curCanvasPos) {
        if (ti == null) {
            return null;
        }
        if (ti.e.getElementClass().getId().equals(CloudFactory.class.getSimpleName())) {
            return null;
        }
        this.diagram.setHint(DiagramHints.ROUTE_ALGORITHM, (Object)new DependencyRouter());
        this.diagram.setHint(DiagramHints.KEY_USE_CONNECTION_FLAGS, (Object)false);
        SysdynElementClassProviders.ISysdynElementClassProvider secp = (SysdynElementClassProviders.ISysdynElementClassProvider)this.elementClassProvider;
        secp.put(ElementClasses.CONNECTION, this.elementClassProvider.get(ConnectionClasses.DEPENDENCY));
        IConnectionAdvisor advisor = (IConnectionAdvisor)this.diagram.getHint(DiagramHints.CONNECTION_ADVISOR);
        if (advisor == null || advisor.canBeginConnection(null, ti.e, ti.t)) {
            return new SysdynConnectTool(ti, mouseId, curCanvasPos);
        }
        return null;
    }

    private ICanvasParticipant getFlowConnectTool(TerminalUtil.TerminalInfo ti, int mouseId, Point2D curCanvasPos) {
        if (ti != null && (ti.e.getElementClass().getId().equals(AuxiliaryFactory.class.getSimpleName()) || ti.e.getElementClass().getId().equals(InputFactory.class.getSimpleName()) || ti.e.getElementClass().getId().equals(ModuleFactory.class.getSimpleName()))) {
            return null;
        }
        this.diagram.setHint(DiagramHints.ROUTE_ALGORITHM, (Object)new FlowRouter());
        this.diagram.setHint(DiagramHints.KEY_USE_CONNECTION_FLAGS, (Object)true);
        SysdynElementClassProviders.ISysdynElementClassProvider secp = (SysdynElementClassProviders.ISysdynElementClassProvider)this.elementClassProvider;
        secp.put(ElementClasses.CONNECTION, this.elementClassProvider.get(ConnectionClasses.FLOW));
        IConnectionAdvisor advisor = (IConnectionAdvisor)this.diagram.getHint(DiagramHints.CONNECTION_ADVISOR);
        if (ti == null || advisor == null || advisor.canBeginConnection(null, ti.e, ti.t)) {
            return new SysdynConnectTool(ti, mouseId, curCanvasPos);
        }
        return null;
    }

    public List<TerminalUtil.TerminalInfo> pickTerminals(Point2D controlPos) {
        Rectangle2D.Double controlPickRect = new Rectangle2D.Double(controlPos.getX() - 10.0, controlPos.getY() - 10.0, 21.0, 21.0);
        Shape canvasPickRect = GeometryUtils.transformShape((Shape)controlPickRect, (AffineTransform)this.util.getInverseTransform());
        return TerminalUtil.pickTerminals((ICanvasContext)this.getContext(), (IDiagram)this.diagram, (Shape)canvasPickRect, (boolean)false, (boolean)true);
    }
}

