/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor.participant;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Set;
import java.util.function.Consumer;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.SGDesignation;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.sysdyn.ui.elements.AuxiliaryFactory;
import org.simantics.sysdyn.ui.elements.CloudFactory;
import org.simantics.sysdyn.ui.elements.InputFactory;
import org.simantics.sysdyn.ui.elements.LoopFactory;
import org.simantics.sysdyn.ui.elements.ShadowFactory;
import org.simantics.sysdyn.ui.elements.StockFactory;
import org.simantics.sysdyn.ui.elements.SysdynElementHints;
import org.simantics.sysdyn.ui.elements.ValveFactory;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.ui.ExceptionUtils;

public class CreateVariablesShortcutParticipant
extends AbstractDiagramParticipant {
    private GraphToDiagramSynchronizer synchronizer;
    private VariableInformation variableInformation;
    @DependencyReflection.Dependency
    MouseUtil mouseUtil;
    @DependencyReflection.Dependency
    Selection selection;
    @DependencyReflection.Dependency
    ElementPainter diagramPainter;
    ShapeNode node;
    G2DParentNode parent;
    private boolean createVar;
    private IDiagram createVarDiagram;

    @SGNodeReflection.SGInit(designation=SGDesignation.CANVAS)
    public void init(G2DParentNode parent) {
        this.parent = parent;
    }

    public void removeSG() {
        this.node.remove();
        this.node = null;
        this.setDirty();
    }

    void updateSG() {
        MouseUtil.MouseInfo mi;
        if (this.node == null) {
            this.node = this.variableInformation.node;
        }
        if ((mi = this.mouseUtil.getMouseInfo(0)) == null) {
            return;
        }
        Point2D newPos = mi.canvasPosition;
        double x = newPos.getX();
        double y = newPos.getY();
        AffineTransform origAt = this.node.getTransform();
        double oldX = origAt.getTranslateX();
        double oldY = origAt.getTranslateY();
        AffineTransform move = new AffineTransform();
        move.setToTranslation(x - oldX, y - oldY);
        AffineTransform at2 = new AffineTransform(origAt);
        at2.preConcatenate(move);
        this.node.setTransform(at2);
        this.setDirty();
    }

    public CreateVariablesShortcutParticipant(GraphToDiagramSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    @EventHandlerReflection.EventHandler(priority=-10)
    public boolean handleKeyboardEvent(KeyEvent ke) {
        if (!Hints.POINTERTOOL.equals(this.getHint(Hints.KEY_TOOL)) || this.getHint(SysdynElementHints.SYSDYN_KEY_TOOL) != null) {
            return false;
        }
        if (ke instanceof KeyEvent.KeyPressedEvent) {
            KeyEvent.KeyPressedEvent kpe = (KeyEvent.KeyPressedEvent)ke;
            if (!kpe.isShiftDown() || this.isEditing()) {
                return false;
            }
            if (kpe.keyCode == 65) {
                this.variableInformation = new VariableInformation(65, "http://www.simantics.org/Sysdyn-1.1/AuxiliarySymbol", (ShapeNode)AuxiliaryFactory.AUX_STATIC_IMAGE.init(this.parent));
            } else if (kpe.keyCode == 83) {
                this.variableInformation = new VariableInformation(83, "http://www.simantics.org/Sysdyn-1.1/StockSymbol", (ShapeNode)StockFactory.STOCK_IMAGE.init(this.parent));
            } else if (kpe.keyCode == 67) {
                this.variableInformation = new VariableInformation(67, "http://www.simantics.org/Sysdyn-1.1/CloudSymbol", (ShapeNode)CloudFactory.CLOUD_IMAGE.init(this.parent));
            } else if (kpe.keyCode == 86) {
                this.variableInformation = new VariableInformation(86, "http://www.simantics.org/Sysdyn-1.1/ValveSymbol", (ShapeNode)ValveFactory.VALVE_STATIC_IMAGE.init(this.parent));
            } else if (kpe.keyCode == 73) {
                this.variableInformation = new VariableInformation(73, "http://www.simantics.org/Sysdyn-1.1/InputSymbol", (ShapeNode)InputFactory.INPUT_IMAGE.init(this.parent));
            } else if (kpe.keyCode == 71) {
                this.variableInformation = new VariableInformation(71, "http://www.simantics.org/Sysdyn-1.1/ShadowSymbol", (ShapeNode)ShadowFactory.GHOST_IMAGE.init(this.parent));
            } else if (kpe.keyCode == 76) {
                this.variableInformation = new VariableInformation(76, "http://www.simantics.org/Sysdyn-1.1/LoopSymbol", (ShapeNode)LoopFactory.LOOP_STATIC_IMAGE.init(this.parent));
            }
            if (this.variableInformation != null) {
                this.updateSG();
                return true;
            }
        }
        if (ke instanceof KeyEvent.KeyReleasedEvent) {
            KeyEvent.KeyReleasedEvent kre = (KeyEvent.KeyReleasedEvent)ke;
            if (this.variableInformation != null && (kre.keyCode == this.variableInformation.shortcutKey || kre.keyCode == 16) && this.node != null) {
                if (this.createVar) {
                    this.createVar = false;
                    this.createVariableOnDiagram(this.createVarDiagram);
                }
                this.variableInformation = null;
                this.removeSG();
                return true;
            }
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=-10)
    public boolean handleMouse(MouseEvent.MouseMovedEvent e) {
        if (this.variableInformation != null) {
            this.updateSG();
        } else if (this.node != null) {
            this.removeSG();
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=100)
    public boolean handleMouseEvent(MouseEvent me) {
        if (!(me instanceof MouseEvent.MouseClickEvent)) {
            return false;
        }
        MouseEvent.MouseClickEvent mce = (MouseEvent.MouseClickEvent)me;
        if (!Hints.POINTERTOOL.equals(this.getHint(Hints.KEY_TOOL)) || this.getHint(SysdynElementHints.SYSDYN_KEY_TOOL) != null) {
            return false;
        }
        if (mce.button != 1 || this.variableInformation == null || mce.stateMask != 64) {
            return false;
        }
        IDiagram d = (IDiagram)this.getHint(DiagramHints.KEY_DIAGRAM);
        if (d == null) {
            return false;
        }
        this.createVar = true;
        this.createVarDiagram = d;
        return true;
    }

    private void createVariableOnDiagram(IDiagram d) {
        DiagramUtils.mutateDiagram((IDiagram)d, (Consumer)new Consumer<DiagramMutator>(){

            @Override
            public void accept(DiagramMutator m) {
                try {
                    Resource r = (Resource)Simantics.getSession().syncRequest(Queries.resource((String)((CreateVariablesShortcutParticipant)CreateVariablesShortcutParticipant.this).variableInformation.symbolURI));
                    ElementClass ec = (ElementClass)Simantics.getSession().syncRequest(DiagramRequests.getElementClass((Resource)r, (IHintObservable)CreateVariablesShortcutParticipant.this.diagram));
                    IElement element = m.newElement(ec);
                    MouseUtil.MouseInfo minfo = CreateVariablesShortcutParticipant.this.mouseUtil.getMouseInfo(0);
                    if (minfo == null) {
                        return;
                    }
                    Point2D p = minfo.canvasPosition;
                    p.setLocation(p.getX() - 5.46, p.getY() + 1.0);
                    ElementUtils.setPos((IElement)element, (Point2D)p);
                }
                catch (DatabaseException e) {
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
            }
        });
        this.synchronizer.getCanvasContext().getContentContext().setDirty();
    }

    private boolean isEditing() {
        int selectionId = 0;
        Set ss = this.selection.getSelection(selectionId);
        if (ss.isEmpty()) {
            return false;
        }
        for (IElement e : ss) {
            for (Object o : e.getHints().values()) {
                TextNode tn;
                if (!(o instanceof TextNode) || !(tn = (TextNode)o).isEditMode()) continue;
                return true;
            }
        }
        return false;
    }

    private class VariableInformation {
        public String symbolURI;
        public ShapeNode node;
        public int shortcutKey;

        public VariableInformation(int shortcutKey, String symbolURI, ShapeNode node) {
            this.symbolURI = symbolURI;
            this.node = node;
            this.shortcutKey = shortcutKey;
        }
    }
}

