/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.modeling.ComponentUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.operation.Layer0X;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.StructuralVariables;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class OpenDiagramFromConfigurationAdapter
extends AbstractResourceEditorAdapter {
    private static final String EDITOR_ID = "org.simantics.sysdyn.ui.diagramViewer";

    public OpenDiagramFromConfigurationAdapter() {
        super("Diagram Editor", Activator.COMPOSITE_ICON);
    }

    protected static String getEditorId() {
        return EDITOR_ID;
    }

    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
        if (g.isInheritedFrom(r, sr.ModuleSymbol)) {
            ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
            StructuralResource2 sr2 = StructuralResource2.getInstance((ReadGraph)g);
            Resource componentType = g.getSingleObject(r, mr.SymbolToComponentType);
            r = g.getSingleObject(componentType, sr2.IsDefinedBy);
        }
        Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
        Resource represents = g.getPossibleObject(r, L0X.Represents);
        if (represents != null && g.isInstanceOf(represents, sr.Configuration)) {
            r = represents;
        }
        return ComponentUtils.compositeHasDiagram((ReadGraph)g, (Resource)r);
    }

    public void openEditor(final Resource r) throws Exception {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                OpenDiagramFromConfigurationAdapter.openEditorHandler(g, r);
            }
        });
    }

    public static void openEditorHandler(ReadGraph g, Resource r) throws DatabaseException {
        Resource cr = r;
        Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
        if (g.isInheritedFrom(r, SysdynResource.getInstance((ReadGraph)g).ModuleSymbol)) {
            Resource configuration;
            ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
            StructuralResource2 sr2 = StructuralResource2.getInstance((ReadGraph)g);
            Resource componentType = g.getSingleObject(r, mr.SymbolToComponentType);
            cr = configuration = g.getSingleObject(componentType, sr2.IsDefinedBy);
        } else {
            Resource represents = g.getPossibleObject(r, L0X.Represents);
            cr = represents != null && g.isInstanceOf(represents, SysdynResource.getInstance((ReadGraph)g).Configuration) ? represents : r;
        }
        final Resource diagram = ComponentUtils.getPossibleCompositeDiagram((ReadGraph)g, (Resource)cr);
        if (diagram == null) {
            return;
        }
        ResourceArray compositePath = StructuralVariables.getCompositeArray((ReadGraph)g, (Resource)cr);
        ResourceArray variablePath = compositePath.removeFromBeginning(1);
        final Resource model = StructuralVariables.getModel((ReadGraph)g, (Resource)compositePath.head());
        if (model == null) {
            return;
        }
        final String rvi = StructuralVariables.getRVI((ReadGraph)g, (ResourceArray)variablePath);
        if (rvi == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    String editorId = OpenDiagramFromConfigurationAdapter.getEditorId();
                    WorkbenchUtils.openEditor((String)editorId, (IEditorInput)new ResourceEditorInput2(editorId, diagram, model, rvi));
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

