/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import java.util.Collection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IDeletableNode;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.adapter.PasteHandler;
import org.simantics.db.layer0.adapter.impl.DefaultPasteHandler;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.ui.utils.ModuleTypeNameValidator;

public class ModuleTypeNode
extends AbstractNode<Resource>
implements IDeletableNode,
IModifiableNode {
    Listener<String> configurationNameSynchronizer;
    private boolean disposed = false;
    private Resource configuration;

    public ModuleTypeNode(Resource resource) {
        super((Object)resource);
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                StructuralResource2 sr2 = StructuralResource2.getInstance((ReadGraph)graph);
                Resource type = graph.getPossibleObject((Resource)ModuleTypeNode.this.data, mr.SymbolToComponentType);
                ModuleTypeNode.this.configuration = graph.getPossibleObject(type, sr2.IsDefinedBy);
            }
        });
        this.configurationNameSynchronizer = new Listener<String>(){

            public void execute(final String result) {
                if (result == null) {
                    return;
                }
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        if (ModuleTypeNode.this.configuration != null) {
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            String currentLabel = (String)graph.getRelatedValue2(ModuleTypeNode.this.configuration, L0.HasLabel, (Binding)Bindings.STRING);
                            if (!currentLabel.equals(result)) {
                                graph.claimLiteral(ModuleTypeNode.this.configuration, L0.HasLabel, (Object)result);
                            }
                        }
                    }
                });
            }

            public void exception(Throwable t) {
                t.printStackTrace();
            }

            public boolean isDisposed() {
                return ModuleTypeNode.this.disposed;
            }
        };
        Simantics.getSession().asyncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                Resource type = graph.getPossibleObject((Resource)ModuleTypeNode.this.data, mr.SymbolToComponentType);
                return (String)(type != null ? graph.getRelatedValue(type, l0.HasName) : null);
            }
        }, this.configurationNameSynchronizer);
    }

    public Labeler.Modifier getModifier(String columnId) {
        Labeler.Modifier modifier = null;
        try {
            modifier = (Labeler.Modifier)Simantics.getSession().syncRequest((Read)new Read<Labeler.Modifier>(){

                public Labeler.Modifier perform(ReadGraph graph) throws ManyObjectsForFunctionalRelationException, ServiceException {
                    ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource type = graph.getPossibleObject((Resource)ModuleTypeNode.this.data, mr.SymbolToComponentType);
                    LabelModifier modifier = new LabelModifier(Simantics.getSession(), type, l0.HasName){

                        public String isValid(String label) {
                            if (!new ModuleTypeNameValidator().isValid((Resource)(this).ModuleTypeNode.this.data, label)) {
                                return "Not valid";
                            }
                            return null;
                        }
                    };
                    return modifier;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return modifier;
    }

    public void delete() throws DeleteException {
        this.disposed = true;
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    StructuralResource2 st = StructuralResource2.getInstance((ReadGraph)graph);
                    ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                    Resource type = graph.getPossibleObject((Resource)ModuleTypeNode.this.data, mr.SymbolToComponentType);
                    Resource model = graph.getSingleObject(type, l0.PartOf);
                    Resource modelConfiguration = graph.getSingleObject(model, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration);
                    if (!((Collection)graph.syncRequest((Read)new ObjectsWithType(modelConfiguration, l0.ConsistsOf, type))).isEmpty()) {
                        throw new ModuleDeleteException("The module is used at the model configuration");
                    }
                    Collection moduleTypes = (Collection)graph.syncRequest((Read)new ObjectsWithType(model, l0.ConsistsOf, st.ComponentType));
                    for (Resource r : moduleTypes) {
                        Resource configuration = graph.getPossibleObject(r, st.IsDefinedBy);
                        if (configuration == null || ((Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, l0.ConsistsOf, type))).isEmpty()) continue;
                        throw new ModuleDeleteException("The module is used at another module: " + graph.getRelatedValue(r, l0.HasName));
                    }
                    IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
                    for (Resource issueSource : (Collection)graph.syncRequest((Read)new ObjectsWithType(type, l0.ConsistsOf, ISSUE.Sources_DependencyTracker))) {
                        for (Resource issue : (Collection)graph.syncRequest((Read)new ObjectsWithType(issueSource, ISSUE.IssueSource_Manages, ISSUE.Issue))) {
                            RemoverUtil.remove((WriteGraph)graph, (Resource)issue);
                        }
                    }
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Removed Module Type " + graph.getRelatedValue2(type, l0.HasName, (Binding)Bindings.STRING) + " " + type.toString()));
                    RemoverUtil.remove((WriteGraph)graph, (Resource)type);
                }
            });
        }
        catch (ModuleDeleteException e) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog dialog = new MessageDialog(shell, "Unable to delete", null, e.message, 1, new String[]{"OK"}, 0);
            dialog.create();
            dialog.open();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public Object getAdapter(Class adapter) {
        if (PasteHandler.class == adapter && this.configuration != null) {
            return new DefaultPasteHandler(this.configuration);
        }
        return super.getAdapter(adapter);
    }

    private class ModuleDeleteException
    extends DatabaseException {
        private static final long serialVersionUID = 4076002781765246919L;
        String message;

        public ModuleDeleteException(String message) {
            this.message = message;
        }
    }
}

