/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.labelrules;

import java.util.Collections;
import java.util.Map;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.ui.browser.labelrules.ModuleTypeLabelRule;
import org.simantics.utils.ui.AdaptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableNameLabelRule
implements LabelRule {
    private static Logger LOGGER = LoggerFactory.getLogger(VariableNameLabelRule.class);
    public static final ModuleTypeLabelRule INSTANCE = new ModuleTypeLabelRule();

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        Variable var = (Variable)AdaptionUtils.adaptToSingle((Object)content, Variable.class);
        return Collections.singletonMap("single", var != null ? String.valueOf(var.getName(graph)) + VariableNameLabelRule.possibleTypeAsString(graph, var) : "No variable");
    }

    private static String possibleTypeAsString(ReadGraph graph, Variable var) throws DatabaseException {
        try {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            String type = (String)graph.getPossibleRelatedValue(var.getType(graph), L0.HasName);
            return " : " + type;
        }
        catch (NullPointerException | DatabaseException e) {
            LOGGER.error("Failed to find type of resource", e);
            return "";
        }
    }
}

