/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.contributions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.graph.contributor.viewpoint.ViewpointContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.browser.nodes.ExperimentNode;
import org.simantics.sysdyn.ui.browser.nodes.HistoryDataNode;
import org.simantics.sysdyn.ui.browser.nodes.SimulationResultNode;
import org.simantics.sysdyn.ui.browser.nodes.SimulationResultSetNode;

public class SimulationResult
extends ViewpointContributor<AbstractNode<Resource>> {
    public Collection<?> getContribution(ReadGraph graph, AbstractNode<Resource> node) throws DatabaseException {
        ArrayList result = new ArrayList();
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        if (!(node instanceof ExperimentNode) && !(node instanceof SimulationResultSetNode)) {
            return result;
        }
        for (final Resource r : (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)node.data, sr.Experiment_result, sr.Result))) {
            if (graph.isInstanceOf(r, sr.HistoryDataset)) {
                result.add(new HistoryDataNode(r));
                continue;
            }
            result.add(new SimulationResultNode(r));
            String resultPath = (String)graph.getPossibleRelatedValue(r, sr.Result_resultFile);
            File file = new File(resultPath);
            if (file.exists()) continue;
            graph.asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    String resultPath = (String)graph.getPossibleRelatedValue(r, SysdynResource.getInstance((ReadGraph)graph).Result_resultFile);
                    File file = new File(resultPath);
                    if (!file.exists()) {
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        graph.deny(r, l0.PartOf);
                        graph.deny(r, graph.getInverse(SysdynResource.getInstance((ReadGraph)graph).Experiment_result));
                    }
                }
            });
        }
        return result;
    }

    public String getViewpointId() {
        return "Standard";
    }
}

