/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.actions;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class OpenSheetAction
implements IDoubleClickAction {
    public void doubleClickEvent(DoubleClickEvent e) throws DatabaseException {
        Resource result = ResourceAdaptionUtils.toSingleResource((Object)e.getResource());
        if (result == null) {
            return;
        }
        ReadGraph graph = e.getGraph();
        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
        final Resource sheet = result;
        if (graph.isInstanceOf(sheet, SHEET.Spreadsheet)) {
            Variable variable = (Variable)graph.adapt(sheet, Variable.class);
            final Resource model = Variables.getModel((ReadGraph)graph, (Variable)variable);
            final RVI rvi = variable.getRVI(graph);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){
                private static final String EDITOR_ID = "org.simantics.spreadsheet.ui.editor2";

                @Override
                public void run() {
                    try {
                        WorkbenchUtils.openEditor((String)EDITOR_ID, (IEditorInput)new ResourceEditorInput2(EDITOR_ID, sheet, model, rvi));
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

