/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui;

import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.issues.Severity;
import org.simantics.utils.FileUtils;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.simantics.sysdyn.ui";
    private static Activator plugin;
    private static LocalResourceManager resourceManager;
    public static String FATAL_SVG_TEXT;
    public static String ERROR_SVG_TEXT;
    public static String WARNING_SVG_TEXT;
    public static ImageDescriptor FATAL_DECORATION_ICON;
    public static ImageDescriptor ERROR_DECORATION_ICON;
    public static ImageDescriptor WARNING_DECORATION_ICON;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ConsoleAppender appender = new ConsoleAppender((Layout)new SimpleLayout());
        BasicConfigurator.configure((Appender)appender);
        Logger.getRootLogger().setLevel(Level.WARN);
        plugin = this;
        Bundle bundle = context.getBundle();
        FATAL_SVG_TEXT = FileUtils.getContents((URL)bundle.getResource("icons/fatal.svg"));
        ERROR_SVG_TEXT = FileUtils.getContents((URL)bundle.getResource("icons/error.svg"));
        WARNING_SVG_TEXT = FileUtils.getContents((URL)bundle.getResource("icons/warning.svg"));
        FATAL_DECORATION_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/fatal_decoration.png"));
        ERROR_DECORATION_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/error_decoration.png"));
        WARNING_DECORATION_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/warning_decoration.png"));
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    protected ImageRegistry createImageRegistry() {
        return super.createImageRegistry();
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(Severity.FATAL.toString(), FATAL_DECORATION_ICON);
        reg.put(Severity.ERROR.toString(), ERROR_DECORATION_ICON);
        reg.put(Severity.WARNING.toString(), WARNING_DECORATION_ICON);
    }

    public static ResourceManager initializeResourceManager(Display display) {
        if (resourceManager == null) {
            resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)display));
        }
        return resourceManager;
    }

    public static ResourceManager getResources() {
        if (resourceManager == null) {
            throw new IllegalStateException("ResourceManager of bundle 'org.simantics.sysdyn.ui' is not initialized.");
        }
        return resourceManager;
    }

    public static URL getDefaultResource(String name) {
        Activator plugin = Activator.getDefault();
        if (plugin == null) {
            throw new IllegalStateException("The plugin is not active.");
        }
        return plugin.getBundle().getResource(name);
    }
}

