/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.rules.domain;

import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.MappingException;
import org.simantics.objmap.rules.domain.IDomainAccessor;

public class RelatedValueAccessor
implements IDomainAccessor<Object> {
    static Logger LOGGER = Logger.getLogger((String)"org.simantics.objmap");
    Resource relation;
    Resource valueType;

    public RelatedValueAccessor(Resource relation, Resource valueType) {
        this.relation = relation;
        this.valueType = valueType;
    }

    @Override
    public Object get(ReadGraph g, Resource element) throws MappingException {
        Resource valueResource;
        block3: {
            try {
                LOGGER.info((Object)"        RelatedValueAccessor.get");
                valueResource = g.getPossibleObject(element, this.relation);
                if (valueResource != null) break block3;
                return null;
            }
            catch (DatabaseException e) {
                throw new MappingException(e);
            }
        }
        return g.getValue(valueResource);
    }

    @Override
    public boolean set(WriteGraph g, Resource element, Object value) throws MappingException {
        Resource valueResource;
        block9: {
            block8: {
                block6: {
                    block7: {
                        try {
                            LOGGER.info((Object)"        RelatedValueAccessor.set");
                            valueResource = g.getPossibleObject(element, this.relation);
                            if (valueResource != null) break block6;
                            if (value != null) break block7;
                            return false;
                        }
                        catch (DatabaseException e) {
                            throw new MappingException(e);
                        }
                    }
                    valueResource = g.newResource();
                    g.claim(valueResource, Layer0.getInstance((ReadGraph)g).InstanceOf, null, this.valueType);
                    g.claim(element, this.relation, valueResource);
                    g.claimValue(valueResource, value);
                    return true;
                }
                if (value != null) break block8;
                g.deny(valueResource);
                return true;
            }
            Object currentValue = g.getValue(valueResource);
            if (!currentValue.equals(value)) break block9;
            return false;
        }
        g.claimValue(valueResource, value);
        return true;
    }
}

