/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modelica.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.modelica.data.DoubleMatrix;
import org.simantics.modelica.data.IntMatrix;
import org.simantics.modelica.data.Matrix;
import org.simantics.modelica.data.StringMatrix;
import org.simantics.modelica.reader.ResultFileReader;
import org.simantics.utils.datastructures.MapList;

public class MatFileReader
implements ResultFileReader {
    private final File file;
    private final List<String> names = new ArrayList<String>();
    private final Map<String, Integer> indices = new HashMap<String, Integer>();
    private HashMap<String, double[]> parameterValues;
    long readBytes = 0L;
    long dataMark = 0L;
    IntMatrix info;
    int[] infoData;
    MatrixHeader dataHeader;

    public MatFileReader(File file) throws IOException {
        this.file = file;
        this.readVariables();
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public int getCount(String item) {
        return this.dataHeader.columns;
    }

    @Override
    public double[] readData(String item) throws IOException {
        this.readBytes = 0L;
        Integer index = this.indices.get(item);
        if (index == null) {
            if (this.parameterValues.containsKey(item)) {
                return this.parameterValues.get(item);
            }
            throw new IOException("Unknown item: " + item);
        }
        InputStream in = this.openStream();
        this.skip(this.dataMark, in);
        double[] data = this.readRow(this.dataHeader, index, in);
        in.close();
        return data;
    }

    @Override
    public double[] readData(String item, int start, int count, int skip) throws IOException {
        this.readBytes = 0L;
        Integer index = this.indices.get(item);
        if (index == null) {
            if (this.parameterValues.containsKey(item)) {
                return this.parameterValues.get(item);
            }
            throw new IOException("Unknown item: " + item);
        }
        InputStream in = this.openStream();
        this.skip(this.dataMark, in);
        double[] data = this.readRow(this.dataHeader, index, start, count, skip, in);
        in.close();
        return data;
    }

    @Override
    public double[][] readData(List<String> items) throws IOException {
        this.readBytes = 0L;
        ArrayList<Integer> indexes = new ArrayList<Integer>(items.size());
        for (String item : items) {
            Integer index = this.indices.get(item);
            if (index == null) {
                throw new IOException("Unknown item: " + item);
            }
            indexes.add(index);
        }
        InputStream in = this.openStream();
        this.skip(this.dataMark, in);
        double[][] data = this.readRows(this.dataHeader, indexes, in);
        in.close();
        return data;
    }

    private InputStream openStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public double[][] readData(List<String> items, int start, int count, int skip) throws IOException {
        this.readBytes = 0L;
        ArrayList<Integer> indexes = new ArrayList<Integer>(items.size());
        for (String item : items) {
            Integer index = this.indices.get(item);
            if (index == null) {
                throw new IOException("Unknown item: " + item);
            }
            indexes.add(index);
        }
        InputStream in = this.openStream();
        this.skip(this.dataMark, in);
        double[][] data = this.readRows(this.dataHeader, indexes, start, count, skip, in);
        in.close();
        return data;
    }

    private void readVariables() throws IOException {
        InputStream in = this.openStream();
        this.readMatrix(in);
        StringMatrix names = (StringMatrix)this.readMatrix(in);
        this.readMatrix(in);
        int i = 0;
        while (i < names.data.length) {
            String s = names.data[i];
            this.names.add(s);
            this.indices.put(s, i);
            ++i;
        }
        this.info = (IntMatrix)this.readMatrix(in);
        if (this.info.rows != 4 || this.info.columns != names.rows) {
            throw new IOException("Invalid result data.");
        }
        this.infoData = this.info.data;
        this.parameterValues = new HashMap();
        DoubleMatrix parameters = (DoubleMatrix)this.readMatrix(in);
        MatFileReader.readDoubleMatrix(parameters, names, 1, 1, this.info, 1, this.parameterValues);
        this.dataHeader = new MatrixHeader(in);
        this.dataMark = this.readBytes;
        in.close();
        int i2 = this.names.size() - 1;
        while (i2 >= 0) {
            if (this.infoData[i2 * 4] != 2) {
                String name = this.names.get(i2);
                this.indices.remove(name);
            }
            --i2;
        }
        Collections.sort(this.names);
    }

    private final int getInt(InputStream in) throws IOException {
        int ch1 = in.read();
        int ch2 = in.read();
        int ch3 = in.read();
        int ch4 = in.read();
        this.readBytes += 4L;
        return (ch1 << 0) + (ch2 << 8) + (ch3 << 16) + (ch4 << 24);
    }

    private final long getLong(InputStream in) throws IOException {
        int ch1 = in.read();
        int ch2 = in.read();
        int ch3 = in.read();
        int ch4 = in.read();
        int ch5 = in.read();
        int ch6 = in.read();
        int ch7 = in.read();
        int ch8 = in.read();
        this.readBytes += 8L;
        return ((long)ch1 << 0) + ((long)ch2 << 8) + ((long)ch3 << 16) + ((long)ch4 << 24) + ((long)ch5 << 32) + ((long)ch6 << 40) + ((long)ch7 << 48) + ((long)ch8 << 56);
    }

    private final double getDouble(InputStream in) throws IOException {
        return Double.longBitsToDouble(this.getLong(in));
    }

    private String getString(InputStream in, int length) throws IOException {
        byte[] buffer = new byte[length];
        int pos = 0;
        while (pos < length) {
            pos += in.read(buffer, pos, length - pos);
        }
        this.readBytes += (long)length;
        return new String(buffer, "UTF-8");
    }

    private Matrix readMatrix(InputStream in) throws IOException {
        int type = this.getInt(in);
        int rows = this.getInt(in);
        int columns = this.getInt(in);
        int imagf = this.getInt(in);
        int namlen = this.getInt(in);
        String name = this.getString(in, namlen - 1);
        in.read();
        ++this.readBytes;
        if (imagf > 0) {
            throw new IOException("Imaginary part of the matrix is not supported (matrix " + name + ").");
        }
        switch (type) {
            case 0: {
                DoubleMatrix matrix = new DoubleMatrix(name, rows, columns);
                int size = rows * columns;
                double[] data = matrix.data;
                int i = 0;
                while (i < size) {
                    data[i] = this.getDouble(in);
                    ++i;
                }
                return matrix;
            }
            case 20: {
                IntMatrix matrix = new IntMatrix(name, rows, columns);
                int size = rows * columns;
                int[] data = matrix.data;
                int i = 0;
                while (i < size) {
                    data[i] = this.getInt(in);
                    ++i;
                }
                return matrix;
            }
            case 51: {
                StringMatrix matrix = new StringMatrix(name, columns);
                String[] data = matrix.data;
                int i = 0;
                while (i < columns) {
                    data[i] = this.getString(in, rows).trim();
                    ++i;
                }
                return matrix;
            }
        }
        throw new IOException("Matrix " + name + " has unsupported data type " + type + ".");
    }

    private Matrix readMatrix(MatrixHeader header, InputStream in) throws IOException {
        switch (header.type) {
            case 0: {
                DoubleMatrix matrix = new DoubleMatrix(header.name, header.rows, header.columns);
                int size = header.rows * header.columns;
                double[] data = matrix.data;
                int i = 0;
                while (i < size) {
                    data[i] = this.getDouble(in);
                    ++i;
                }
                return matrix;
            }
            case 20: {
                IntMatrix matrix = new IntMatrix(header.name, header.rows, header.columns);
                int size = header.rows * header.columns;
                int[] data = matrix.data;
                int i = 0;
                while (i < size) {
                    data[i] = this.getInt(in);
                    ++i;
                }
                return matrix;
            }
            case 51: {
                StringMatrix matrix = new StringMatrix(header.name, header.columns);
                String[] data = matrix.data;
                int i = 0;
                while (i < header.columns) {
                    data[i] = this.getString(in, header.rows).trim();
                    ++i;
                }
                return matrix;
            }
        }
        throw new IOException("Matrix " + header.name + " has unsupported data type " + header.type + ".");
    }

    private double[] readRow(MatrixHeader header, int column, InputStream in) throws IOException {
        if (header.type != 0) {
            throw new IOException("Only double type supported");
        }
        if (this.infoData[column * 4] != 2) {
            throw new IOException();
        }
        int size = header.columns;
        int rows = header.rows;
        double[] v = new double[size];
        int sc = this.infoData[column * 4 + 1];
        int c = sc > 0 ? sc - 1 : -sc - 1;
        this.skip(c * 8, in);
        int j = 0;
        while (j < v.length) {
            double d;
            v[j] = d = this.getDouble(in);
            this.skip((rows - 1) * 8, in);
            ++j;
        }
        if (sc < 0) {
            j = 0;
            while (j < v.length) {
                v[j] = -v[j];
                ++j;
            }
        }
        return v;
    }

    private double[] readRow(MatrixHeader header, int row, int start, int count, int skip, InputStream in) throws IOException {
        if (header.type != 0) {
            throw new IOException("Only double type supported");
        }
        if (this.infoData[row * 4] != 2) {
            throw new IOException();
        }
        int size = header.columns;
        if (start + count * (skip + 1) - skip > size) {
            throw new IndexOutOfBoundsException();
        }
        int rows = header.rows;
        double[] v = new double[count];
        int sc = this.infoData[row * 4 + 1];
        long c = sc > 0 ? sc - 1 : -sc - 1;
        this.skip((c + (long)start * (long)rows) * 8L, in);
        int j = 0;
        while (j < v.length) {
            double d;
            v[j] = d = this.getDouble(in);
            this.skip((rows * skip + rows - 1) * 8, in);
            ++j;
        }
        if (sc < 0) {
            j = 0;
            while (j < v.length) {
                v[j] = -v[j];
                ++j;
            }
        }
        return v;
    }

    private double[][] readRows(MatrixHeader header, List<Integer> unSortedRows, InputStream in) throws IOException {
        if (header.type != 0) {
            throw new IOException("Only double type supported");
        }
        for (int row : unSortedRows) {
            if (this.infoData[row * 4] == 2) continue;
            throw new IOException();
        }
        int size = header.columns;
        int rows = header.rows;
        int[] usc = new int[unSortedRows.size()];
        int[] uc = new int[unSortedRows.size()];
        double[][] vs = new double[unSortedRows.size()][];
        int i = 0;
        while (i < unSortedRows.size()) {
            int row = unSortedRows.get(i);
            usc[i] = this.infoData[row * 4 + 1];
            uc[i] = usc[i] > 0 ? usc[i] - 1 : -usc[i] - 1;
            ++i;
        }
        MapList cToRow = new MapList();
        ArrayList<Integer> sortedCs = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < unSortedRows.size()) {
            cToRow.add((Object)uc[i2], (Object)unSortedRows.get(i2));
            sortedCs.add(uc[i2]);
            ++i2;
        }
        ArrayList<Integer> sortedRows = new ArrayList<Integer>();
        int[] sc = new int[sortedCs.size()];
        int[] c = new int[sortedCs.size()];
        Collections.sort(sortedCs);
        int i3 = 0;
        while (i3 < sortedCs.size()) {
            int row = (Integer)cToRow.getValues((Object)((Integer)sortedCs.get(i3))).get(0);
            sortedRows.add(row);
            sc[i3] = usc[unSortedRows.indexOf(row)];
            c[i3] = uc[unSortedRows.indexOf(row)];
            vs[i3] = new double[size];
            ++i3;
        }
        this.skip((long)c[0] * 8L, in);
        int j = 0;
        while (j < size) {
            int index = 0;
            while (index < sortedRows.size()) {
                double d;
                vs[index][j] = d = this.getDouble(in);
                if (index < sortedRows.size() - 1) {
                    this.skip((c[index + 1] - c[index] - 1) * 8, in);
                } else {
                    this.skip((rows - c[index] - 1 + c[0]) * 8, in);
                }
                ++index;
            }
            ++j;
        }
        i3 = 0;
        while (i3 < sortedRows.size()) {
            if (sc[i3] < 0) {
                int j2 = 0;
                while (j2 < vs[i3].length) {
                    vs[i3][j2] = -vs[i3][j2];
                    ++j2;
                }
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < unSortedRows.size()) {
            int rRow = unSortedRows.get(i3);
            if (i3 < sortedRows.size()) {
                int row = (Integer)sortedRows.get(i3);
                if (row != rRow) {
                    int ri = sortedRows.indexOf(rRow);
                    double[] v = vs[i3];
                    vs[i3] = vs[ri];
                    vs[ri] = v;
                    sortedRows.set(i3, rRow);
                    sortedRows.set(ri, row);
                }
            } else {
                int uci = uc[i3];
                int row = (Integer)cToRow.getValues((Object)uci).get(0);
                int ri = sortedRows.indexOf(row);
                vs[i3] = vs[ri];
            }
            ++i3;
        }
        return vs;
    }

    private double[][] readRows(MatrixHeader header, List<Integer> unSortedRows, int start, int count, int skip, InputStream in) throws IOException {
        if (header.type != 0) {
            throw new IOException("Only double type supported");
        }
        for (int row : unSortedRows) {
            if (this.infoData[row * 4] == 2) continue;
            throw new IOException();
        }
        int size = header.columns;
        int rows = header.rows;
        if (start + count * (skip + 1) > size) {
            throw new IndexOutOfBoundsException();
        }
        int[] usc = new int[unSortedRows.size()];
        int[] uc = new int[unSortedRows.size()];
        double[][] vs = new double[unSortedRows.size()][];
        int i = 0;
        while (i < unSortedRows.size()) {
            int row = unSortedRows.get(i);
            usc[i] = this.infoData[row * 4 + 1];
            uc[i] = usc[i] > 0 ? usc[i] - 1 : -usc[i] - 1;
            ++i;
        }
        MapList cToRow = new MapList();
        ArrayList<Integer> sortedCs = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < unSortedRows.size()) {
            cToRow.add((Object)uc[i2], (Object)unSortedRows.get(i2));
            if (!sortedCs.contains(uc[i2])) {
                sortedCs.add(uc[i2]);
            }
            ++i2;
        }
        ArrayList<Integer> sortedRows = new ArrayList<Integer>();
        int[] sc = new int[sortedCs.size()];
        int[] c = new int[sortedCs.size()];
        Collections.sort(sortedCs);
        int i3 = 0;
        while (i3 < sortedCs.size()) {
            int row = (Integer)cToRow.getValues((Object)((Integer)sortedCs.get(i3))).get(0);
            sortedRows.add(row);
            sc[i3] = usc[unSortedRows.indexOf(row)];
            c[i3] = uc[unSortedRows.indexOf(row)];
            vs[i3] = new double[count];
            ++i3;
        }
        long s = start;
        s *= (long)rows;
        this.skip(s *= 8L, in);
        this.skip(c[0] * 8, in);
        int j = 0;
        while (j < count) {
            int index = 0;
            while (index < sortedRows.size()) {
                double d;
                vs[index][j] = d = this.getDouble(in);
                if (index < sortedRows.size() - 1) {
                    this.skip((c[index + 1] - c[index] - 1) * 8, in);
                } else {
                    this.skip((rows - c[index] - 1 + c[0]) * 8, in);
                }
                ++index;
            }
            if (skip > 0) {
                this.skip(skip * rows * 8, in);
            }
            ++j;
        }
        int i4 = 0;
        while (i4 < sortedRows.size()) {
            if (sc[i4] < 0) {
                int j2 = 0;
                while (j2 < vs[i4].length) {
                    vs[i4][j2] = -vs[i4][j2];
                    ++j2;
                }
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < unSortedRows.size()) {
            int rRow = unSortedRows.get(i4);
            if (i4 < sortedRows.size()) {
                int row = (Integer)sortedRows.get(i4);
                if (row != rRow) {
                    int ri = sortedRows.indexOf(rRow);
                    double[] v = vs[i4];
                    vs[i4] = vs[ri];
                    vs[ri] = v;
                    sortedRows.set(i4, rRow);
                    sortedRows.set(ri, row);
                }
            } else {
                int uci = uc[i4];
                int row = (Integer)cToRow.getValues((Object)uci).get(0);
                int ri = sortedRows.indexOf(row);
                vs[i4] = vs[ri];
            }
            ++i4;
        }
        return vs;
    }

    private void skip(long skipBytes, InputStream in) throws IOException {
        long skip = 0L;
        while (skip < skipBytes) {
            skip += in.skip(skipBytes - skip);
        }
    }

    private static void readDoubleMatrix(DoubleMatrix matrix, StringMatrix names, int dataMatrixNumber, int startIndex, IntMatrix info, int outputInterval, HashMap<String, double[]> result) {
        double[] valueData = matrix.data;
        int[] infoData = info.data;
        int rows = matrix.rows;
        int i = startIndex;
        while (i < info.columns) {
            if (infoData[i * 4] == dataMatrixNumber) {
                int size = matrix.columns % outputInterval != 0 ? matrix.columns / outputInterval + 1 : matrix.columns;
                double[] v = new double[size];
                int sc = infoData[i * 4 + 1];
                int c = sc > 0 ? sc - 1 : -sc - 1;
                int j = 0;
                while (j < v.length) {
                    int adjusted = j * outputInterval;
                    if (adjusted >= matrix.columns) {
                        adjusted = matrix.columns - 1;
                    }
                    v[j] = valueData[rows * adjusted + c];
                    ++j;
                }
                if (sc < 0) {
                    j = 0;
                    while (j < v.length) {
                        v[j] = -v[j];
                        ++j;
                    }
                }
                result.put(names.data[i], v);
            }
            ++i;
        }
    }

    public String toString() {
        return this.file.getName();
    }

    private class MatrixHeader {
        int type;
        int rows;
        int columns;
        int imagf;
        int namlen;
        String name;

        public MatrixHeader(InputStream in) throws IOException {
            this.type = MatFileReader.this.getInt(in);
            this.rows = MatFileReader.this.getInt(in);
            this.columns = MatFileReader.this.getInt(in);
            this.imagf = MatFileReader.this.getInt(in);
            this.namlen = MatFileReader.this.getInt(in);
            this.name = MatFileReader.this.getString(in, this.namlen - 1);
            in.read();
            ++MatFileReader.this.readBytes;
            if (this.imagf > 0) {
                throw new IOException("Imaginary part of the matrix is not supported (matrix " + this.name + ").");
            }
        }
    }
}

