/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modelica.data;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.simantics.modelica.data.DataSet;
import org.simantics.modelica.data.MatSimulationResult;
import org.simantics.modelica.reader.ResultFileReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimulationResult {
    protected List<DataSet> variables = new ArrayList<DataSet>();
    protected List<DataSet> initials = new ArrayList<DataSet>();
    protected int numberOfLines = 0;
    protected ResultFileReader resultFileReader;
    protected double[] allTimes;
    protected int skip;
    protected HashMap<String, ArrayList<TimeValuePair>> errors = new HashMap();
    static final Pattern p1 = Pattern.compile("DataSet: ([^ ]*)");

    static String getLine(InputStream stream) {
        if (stream == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        try {
            while (true) {
                int c;
                if ((c = stream.read()) == -1) {
                    stream = null;
                    return b.toString();
                }
                if (c == 10) {
                    return b.toString();
                }
                if (c == 13) continue;
                b.append((char)c);
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public void readInits(File file) throws FileNotFoundException, IOException {
        if (file.getName().endsWith("txt")) {
            InputStream is = this.openStream(file);
            this.readInitsTXT(is);
            is.close();
        } else if (file.getName().endsWith("xml")) {
            this.readInitsXML(file.getAbsolutePath());
        }
    }

    public void readInitsXML(String file) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(file));
            XPath xpath = XPathFactory.newInstance().newXPath();
            double[] times = new double[2];
            Node node = (Node)xpath.evaluate("//fmiModelDescription/DefaultExperiment/@startTime", doc, XPathConstants.NODE);
            times[0] = Double.parseDouble(node.getNodeValue());
            node = (Node)xpath.evaluate("//fmiModelDescription/DefaultExperiment/@stopTime", doc, XPathConstants.NODE);
            times[1] = Double.parseDouble(node.getNodeValue());
            NodeList nodes = (NodeList)xpath.evaluate("//fmiModelDescription/ModelVariables/ScalarVariable[@variability='parameter']", doc, XPathConstants.NODESET);
            int idx = 0;
            while (idx < nodes.getLength()) {
                Node n = nodes.item(idx);
                String name = n.getAttributes().getNamedItem("name").getNodeValue();
                this.addToInitials(name, n, times);
                ++idx;
            }
            NodeList allAliasVariables = (NodeList)xpath.evaluate("//fmiModelDescription/ModelVariables/ScalarVariable[@alias='alias']", doc, XPathConstants.NODESET);
            int i = 0;
            while (i < allAliasVariables.getLength()) {
                Node n = allAliasVariables.item(i);
                String name = n.getAttributes().getNamedItem("name").getNodeValue();
                Node aliasVariableProperty = n.getAttributes().getNamedItem("aliasVariable");
                String aliasVariableName = aliasVariableProperty.getNodeValue();
                if ((n = (Node)xpath.evaluate("//fmiModelDescription/ModelVariables/ScalarVariable[@name='" + aliasVariableName + "' and @variability='parameter']", doc, XPathConstants.NODE)) != null) {
                    this.addToInitials(name, n, times);
                }
                ++i;
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void addToInitials(String name, Node node, double[] times) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().equals("Real")) {
                Double d = Double.parseDouble(child.getAttributes().getNamedItem("start").getNodeValue());
                double[] values = new double[]{d, d};
                this.initials.add(new DataSet(name, times, values));
                break;
            }
            ++i;
        }
    }

    public void readInitsTXT(InputStream stream) {
        HashMap<String, Double> mappedInitials = new HashMap<String, Double>();
        while (true) {
            String line;
            if ((line = SimulationResult.getLine(stream)) == null) {
                return;
            }
            if (line.isEmpty()) break;
            if (!line.contains("//")) continue;
            String[] nn = line.split("//", 2);
            try {
                double value = Double.parseDouble(nn[0].trim());
                String key = nn[1].trim();
                mappedInitials.put(key, value);
            }
            catch (NumberFormatException value) {}
        }
        double startTime = (Double)mappedInitials.get("start value");
        double stopTime = (Double)mappedInitials.get("stop value");
        double[] times = new double[]{startTime, stopTime};
        for (String key : mappedInitials.keySet()) {
            double d = (Double)mappedInitials.get(key);
            double[] values = new double[]{d, d};
            this.initials.add(new DataSet(key, times, values));
        }
    }

    public void read(File file) throws FileNotFoundException, IOException {
        this.read(file, 1);
    }

    public void read(File file, int interval) throws FileNotFoundException, IOException {
        this.initRead(file);
        this.readAll(file, interval);
    }

    public void initRead(File file) throws FileNotFoundException, IOException {
        if (!(this instanceof MatSimulationResult)) {
            FileReader fr = new FileReader(file);
            LineNumberReader lnr = new LineNumberReader(fr);
            lnr.skip(Long.MAX_VALUE);
            this.numberOfLines = lnr.getLineNumber() - 1;
            lnr.close();
            fr.close();
        }
    }

    public void readAll(File file, int interval) throws FileNotFoundException, IOException {
        InputStream is = this.openStream(file);
        this.read(is, interval);
        is.close();
    }

    protected InputStream openStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    public void read(InputStream stream, int outputInterval) {
        String line;
        do {
            if ((line = SimulationResult.getLine(stream)) != null) continue;
            return;
        } while (!line.isEmpty());
        Matcher matcher;
        while ((matcher = p1.matcher(SimulationResult.getLine(stream))).matches()) {
            String name = matcher.group(1);
            double[] dtimes = new double[this.numberOfLines];
            double[] dvalues = new double[this.numberOfLines];
            int i = 0;
            while (true) {
                String line2;
                if ((line2 = SimulationResult.getLine(stream)) == null) {
                    return;
                }
                if (line2.isEmpty()) break;
                String[] nn = line2.split(", ", 2);
                dtimes[i] = Double.parseDouble(nn[0]);
                dvalues[i] = Double.parseDouble(nn[1]);
                ++i;
            }
            this.variables.add(new DataSet(name, dtimes, dvalues));
        }
        return;
    }

    public void filter() {
        ArrayList<DataSet> newVariables = new ArrayList<DataSet>();
        for (DataSet dataSet : this.variables) {
            if (dataSet.name.contains("$") || dataSet.name.contains("der(")) continue;
            newVariables.add(dataSet);
        }
        this.variables = newVariables;
    }

    public List<DataSet> getVariableDataSets() {
        return this.variables;
    }

    public List<DataSet> getInitialValueDataSets() {
        return this.initials;
    }

    public DataSet getDataSet(String name) {
        for (DataSet set : this.variables) {
            if (!set.name.equals(name)) continue;
            return set;
        }
        for (DataSet set : this.initials) {
            if (!set.name.equals(name)) continue;
            return set;
        }
        return null;
    }

    public String getResultReadErrors() {
        StringBuilder errorString = new StringBuilder();
        if (!this.errors.isEmpty()) {
            errorString.append("Number format errors (Time, Value):\n");
            for (String key : this.errors.keySet()) {
                errorString.append("\n" + key + ":\n");
                for (TimeValuePair tv : this.errors.get(key)) {
                    errorString.append("    " + tv.time + ", " + tv.value + "\n");
                }
            }
        }
        return errorString.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataSet readVariable(String variable, File file) throws FileNotFoundException, IOException {
        if (this.resultFileReader == null) {
            return null;
        }
        List<String> names = this.resultFileReader.getNames();
        if (!names.contains(variable)) {
            return null;
        }
        double[] resArray = this.resultFileReader.readData(variable, 0, this.allTimes.length, this.skip);
        double[] timesArray = this.allTimes;
        if (resArray.length == 2 && timesArray.length > 2) {
            timesArray = new double[]{timesArray[0], timesArray[timesArray.length - 1]};
        }
        DataSet ds = new DataSet(variable, timesArray, resArray);
        try {
            for (DataSet tempds : this.variables) {
                if (!tempds.name.equals(variable)) continue;
                return null;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        this.variables.add(ds);
        return ds;
    }

    public void readMissingVariables(File file) throws FileNotFoundException, IOException {
        List<String> names = this.resultFileReader.getNames();
        for (String variable : names) {
            boolean matchFound = false;
            for (DataSet tempDs : this.variables) {
                if (!tempDs.name.equals(variable)) continue;
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            this.readVariable(variable, file);
        }
    }

    public void readTime(File file, int interval) throws FileNotFoundException, IOException {
        this.skip = interval - 1;
        int totalCount = this.resultFileReader.getCount("time");
        int count = totalCount / interval;
        if (totalCount % interval != 0) {
            ++count;
        }
        this.allTimes = this.resultFileReader.readData("time", 0, count, this.skip);
    }

    protected class TimeValuePair {
        public String time;
        public String value;

        public TimeValuePair(String time, String value) {
            this.time = time;
            this.value = value;
        }
    }
}

