/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modelica.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.simantics.modelica.data.DoubleMatrix;
import org.simantics.modelica.data.IntMatrix;
import org.simantics.modelica.data.Matrix;
import org.simantics.modelica.data.StringMatrix;

public class Mat4Reader {
    InputStream in;

    public Mat4Reader(InputStream in) {
        this.in = in;
    }

    private final int getInt() throws IOException {
        int ch1 = this.in.read();
        int ch2 = this.in.read();
        int ch3 = this.in.read();
        int ch4 = this.in.read();
        return (ch1 << 0) + (ch2 << 8) + (ch3 << 16) + (ch4 << 24);
    }

    private final long getLong() throws IOException {
        int ch1 = this.in.read();
        int ch2 = this.in.read();
        int ch3 = this.in.read();
        int ch4 = this.in.read();
        int ch5 = this.in.read();
        int ch6 = this.in.read();
        int ch7 = this.in.read();
        int ch8 = this.in.read();
        return ((long)ch1 << 0) + ((long)ch2 << 8) + ((long)ch3 << 16) + ((long)ch4 << 24) + ((long)ch5 << 32) + ((long)ch6 << 40) + ((long)ch7 << 48) + ((long)ch8 << 56);
    }

    private final double getDouble() throws IOException {
        return Double.longBitsToDouble(this.getLong());
    }

    private String getString(int length) throws IOException {
        byte[] buffer = new byte[length];
        int pos = 0;
        while (pos < length) {
            pos += this.in.read(buffer, pos, length - pos);
        }
        return new String(buffer, "UTF-8");
    }

    public Matrix readMatrix() throws IOException {
        int type = this.getInt();
        int rows = this.getInt();
        int columns = this.getInt();
        int imagf = this.getInt();
        int namlen = this.getInt();
        String name = this.getString(namlen - 1);
        this.in.read();
        if (imagf > 0) {
            throw new IOException("Imaginary part of the matrix is not supported (matrix " + name + ").");
        }
        switch (type) {
            case 0: {
                DoubleMatrix matrix = new DoubleMatrix(name, rows, columns);
                int size = rows * columns;
                double[] data = matrix.data;
                int i = 0;
                while (i < size) {
                    data[i] = this.getDouble();
                    ++i;
                }
                return matrix;
            }
            case 20: {
                IntMatrix matrix = new IntMatrix(name, rows, columns);
                int size = rows * columns;
                int[] data = matrix.data;
                int i = 0;
                while (i < size) {
                    data[i] = this.getInt();
                    ++i;
                }
                return matrix;
            }
            case 51: {
                StringMatrix matrix = new StringMatrix(name, columns);
                String[] data = matrix.data;
                int i = 0;
                while (i < columns) {
                    data[i] = this.getString(rows).trim();
                    ++i;
                }
                return matrix;
            }
        }
        throw new IOException("Matrix " + name + " has unsupported data type " + type + ".");
    }

    public static Map<String, double[]> read(InputStream in, int outputInterval) throws IOException {
        Mat4Reader reader = new Mat4Reader(in);
        reader.readMatrix();
        StringMatrix names = (StringMatrix)reader.readMatrix();
        reader.readMatrix();
        IntMatrix info = (IntMatrix)reader.readMatrix();
        if (info.rows != 4 || info.columns != names.rows) {
            throw new IOException("Invalid result data.");
        }
        HashMap<String, double[]> result = new HashMap<String, double[]>();
        DoubleMatrix parameters = (DoubleMatrix)reader.readMatrix();
        Mat4Reader.readDoubleMatrix(parameters, names, 1, 1, info, 1, result);
        DoubleMatrix values = (DoubleMatrix)reader.readMatrix();
        Mat4Reader.readDoubleMatrix(values, names, 2, 0, info, outputInterval, result);
        in.close();
        return result;
    }

    private static void readDoubleMatrix(DoubleMatrix matrix, StringMatrix names, int dataMatrixNumber, int startIndex, IntMatrix info, int outputInterval, HashMap<String, double[]> result) {
        double[] valueData = matrix.data;
        int[] infoData = info.data;
        int rows = matrix.rows;
        int i = startIndex;
        while (i < info.columns) {
            if (infoData[i * 4] == dataMatrixNumber) {
                int size = matrix.columns % outputInterval != 0 ? matrix.columns / outputInterval + 1 : matrix.columns;
                double[] v = new double[size];
                int sc = infoData[i * 4 + 1];
                int c = sc > 0 ? sc - 1 : -sc - 1;
                int j = 0;
                while (j < v.length) {
                    int adjusted = j * outputInterval;
                    if (adjusted >= matrix.columns) {
                        adjusted = matrix.columns - 1;
                    }
                    v[j] = valueData[rows * adjusted + c];
                    ++j;
                }
                if (sc < 0) {
                    j = 0;
                    while (j < v.length) {
                        v[j] = -v[j];
                        ++j;
                    }
                }
                result.put(names.data[i], v);
            }
            ++i;
        }
    }
}

