/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties.bar;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ITrackedColorProvider;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.TrackedModifyEvent;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.jfreechart.chart.properties.AdjustableTab;
import org.simantics.jfreechart.chart.properties.AxisHidePropertyComposite;
import org.simantics.jfreechart.chart.properties.ColorPicker;
import org.simantics.jfreechart.chart.properties.DoubleValidator;
import org.simantics.jfreechart.chart.properties.JFreeChartPropertyColorProvider;
import org.simantics.jfreechart.chart.properties.TrackedSpinner;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.chart.property.DoublePropertyFactory;
import org.simantics.modeling.ui.chart.property.DoublePropertyModifier;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.ui.AdaptionUtils;

public class BarAxisTab
extends AdjustableTab
implements Widget {
    private TrackedSpinner angle;
    private Integer angleInt = null;
    private WidgetSupportImpl domainAxisSupport = new WidgetSupportImpl();
    private WidgetSupportImpl rangeAxisSupport = new WidgetSupportImpl();
    private TrackedText rangelabel;
    private TrackedText rangemin;
    private TrackedText rangemax;
    private ScrolledComposite sc;
    private Group domainGroup;
    private Label labelLabel;
    private AxisHidePropertyComposite axisHide;
    private Label angleLabel;
    private Composite angleComposite;
    private Label labelColor;
    private ColorPicker colorPicker;
    private Group rangeGroup;
    private Label labelLabel2;
    private Label labelMin;
    private Composite minmax;
    private Label labelMax;
    private Label labelColor2;
    private TrackedText rangelabel2;
    private AxisHidePropertyComposite axisHide2;
    private ColorPicker colorPicker2;
    private Composite rangeComposite;
    private Composite domainComposite;

    public BarAxisTab(Object id) {
        super(id);
    }

    public void setInput(final ISessionContext context, Object input) {
        final Resource chart = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
        if (chart == null) {
            return;
        }
        context.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                Resource plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(chart, l0.ConsistsOf, jfree.Plot));
                if (plot == null) {
                    return;
                }
                final Resource rangeAxis = graph.getPossibleObject(plot, jfree.Plot_rangeAxis);
                final Resource domainAxis = graph.getPossibleObject(plot, jfree.Plot_domainAxis);
                if (rangeAxis == null && domainAxis == null) {
                    return;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (rangeAxis != null) {
                            BarAxisTab.this.rangeAxisSupport.fireInput(context, (Object)new StructuredSelection((Object)rangeAxis));
                        }
                        if (domainAxis != null) {
                            BarAxisTab.this.domainAxisSupport.fireInput(context, (Object)new StructuredSelection((Object)domainAxis));
                        }
                    }
                });
            }
        });
    }

    @Override
    protected void createAndAddControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        support.register((Widget)this);
        this.sc = new ScrolledComposite(body, 768);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.composite = new Composite((Composite)this.sc, 0);
        this.domainGroup = new Group(this.composite, 0);
        this.domainGroup.setText("Domain axis");
        this.domainComposite = new Composite((Composite)this.domainGroup, 0);
        this.labelLabel = new Label(this.domainComposite, 0);
        this.labelLabel.setText("Label:");
        this.rangelabel = new TrackedText(this.domainComposite, (WidgetSupport)this.domainAxisSupport, 2048);
        this.rangelabel.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasLabel", ""));
        this.rangelabel.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasLabel"));
        this.rangelabel.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.rangelabel.getResourceManager()));
        this.angleLabel = new Label(this.domainComposite, 0);
        this.angleLabel.setText("Label angle:");
        this.angleComposite = new Composite(this.domainComposite, 0);
        this.angle = new TrackedSpinner(this.angleComposite, (WidgetSupport)this.domainAxisSupport, 2048);
        this.angle.setSelectionFactory((ReadFactory<?, Integer>)new AngleSelectionFactory());
        this.angle.addModifyListener(new AngleModifyListener());
        this.angle.setMinimum(0);
        this.angle.setMaximum(90);
        this.angle.getWidget().setIncrement(5);
        this.labelColor = new Label(this.domainComposite, 0);
        this.labelColor.setText("Color:");
        this.colorPicker = new ColorPicker(this.domainComposite, context, (WidgetSupport)this.domainAxisSupport, 0);
        this.axisHide = new AxisHidePropertyComposite((Composite)this.domainGroup, context, (WidgetSupport)this.domainAxisSupport, 0);
        this.rangeGroup = new Group(this.composite, 0);
        this.rangeGroup.setText("Range axis");
        this.rangeComposite = new Composite((Composite)this.rangeGroup, 0);
        this.labelLabel2 = new Label(this.rangeComposite, 0);
        this.labelLabel2.setText("Label:");
        this.labelLabel2.setAlignment(131072);
        this.rangelabel2 = new TrackedText(this.rangeComposite, (WidgetSupport)this.rangeAxisSupport, 2048);
        this.rangelabel2.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasLabel", ""));
        this.rangelabel2.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasLabel"));
        this.rangelabel2.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.rangelabel2.getResourceManager()));
        this.labelMin = new Label(this.rangeComposite, 0);
        this.labelMin.setText("Min:");
        this.minmax = new Composite(this.rangeComposite, 0);
        this.rangemin = new TrackedText(this.minmax, (WidgetSupport)this.rangeAxisSupport, 2048);
        this.rangemin.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.rangemin.getResourceManager()));
        this.rangemin.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/JFreeChart-1.0/Axis/min"));
        this.rangemin.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/JFreeChart-1.0/Axis/min"));
        this.rangemin.setInputValidator((IInputValidator)new DoubleValidator(true));
        this.labelMax = new Label(this.minmax, 0);
        this.labelMax.setText("Max:");
        this.rangemax = new TrackedText(this.minmax, (WidgetSupport)this.rangeAxisSupport, 2048);
        this.rangemax.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.rangemax.getResourceManager()));
        this.rangemax.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/JFreeChart-1.0/Axis/max"));
        this.rangemax.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/JFreeChart-1.0/Axis/max"));
        this.rangemax.setInputValidator((IInputValidator)new DoubleValidator(true));
        this.labelColor2 = new Label(this.rangeComposite, 0);
        this.labelColor2.setText("Color:");
        this.colorPicker2 = new ColorPicker(this.rangeComposite, context, (WidgetSupport)this.rangeAxisSupport, 0);
        this.axisHide2 = new AxisHidePropertyComposite((Composite)this.rangeGroup, context, (WidgetSupport)this.rangeAxisSupport, 0);
        this.sc.setContent((Control)this.composite);
    }

    @Override
    protected void createControlLayoutVertical() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sc);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo((Composite)this.sc);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.domainGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(1).applyTo((Composite)this.domainGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.domainComposite);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(this.domainComposite);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelLabel);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.rangelabel.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.angleLabel);
        GridDataFactory.fillDefaults().applyTo((Control)this.angleComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.angleComposite);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, true).applyTo((Control)this.angle.getWidget());
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000008, 0x1000000).applyTo((Control)this.labelColor);
        GridDataFactory.fillDefaults().grab(false, true).minSize(-1, 31).align(1, 0x1000000).applyTo((Control)this.colorPicker);
        GridDataFactory.fillDefaults().applyTo((Control)this.axisHide);
        this.domainGroup.layout();
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.rangeGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(1).applyTo((Composite)this.rangeGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.rangeComposite);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(this.rangeComposite);
        GridDataFactory.fillDefaults().hint(this.angleLabel.getBounds().width, -1).align(0x1000008, 0x1000000).applyTo((Control)this.labelLabel2);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.rangelabel2.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelMin);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, true).applyTo((Control)this.minmax);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.minmax);
        GridDataFactory.fillDefaults().hint(50, -1).applyTo((Control)this.rangemax.getWidget());
        GridDataFactory.fillDefaults().hint(50, -1).applyTo((Control)this.rangemin.getWidget());
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000008, 0x1000000).applyTo((Control)this.labelColor2);
        GridDataFactory.fillDefaults().grab(false, true).minSize(-1, 31).align(1, 0x1000000).applyTo((Control)this.colorPicker2);
        GridDataFactory.fillDefaults().applyTo((Control)this.axisHide2);
        Point size = this.composite.computeSize(-1, -1);
        this.sc.setMinSize(size);
    }

    @Override
    protected void createControlLayoutHorizontal(boolean wideScreen) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sc);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo((Composite)this.sc);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.domainGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.domainGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.domainComposite);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.domainComposite);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelLabel);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.rangelabel.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.angleLabel);
        GridDataFactory.fillDefaults().applyTo((Control)this.angleComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.angleComposite);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, true).applyTo((Control)this.angle.getWidget());
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)this.labelColor);
        GridDataFactory.fillDefaults().grab(false, true).minSize(-1, -1).align(1, 0x1000000).applyTo((Control)this.colorPicker);
        GridDataFactory.fillDefaults().applyTo((Control)this.axisHide);
        this.domainGroup.layout();
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.rangeGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.rangeGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.rangeComposite);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.rangeComposite);
        GridDataFactory.fillDefaults().hint(this.angleLabel.getBounds().width, -1).align(0x1000008, 0x1000000).applyTo((Control)this.labelLabel2);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.rangelabel2.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelMin);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, true).applyTo((Control)this.minmax);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.minmax);
        GridDataFactory.fillDefaults().hint(-1, -1).applyTo((Control)this.rangemax.getWidget());
        GridDataFactory.fillDefaults().hint(-1, -1).applyTo((Control)this.rangemin.getWidget());
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)this.labelColor2);
        GridDataFactory.fillDefaults().grab(false, true).minSize(-1, -1).align(1, 0x1000000).applyTo((Control)this.colorPicker2);
        GridDataFactory.fillDefaults().applyTo((Control)this.axisHide2);
        Point size = this.composite.computeSize(-1, -1);
        this.sc.setMinSize(size);
    }

    private class AngleModifyListener
    implements TextModifyListener,
    Widget {
        private ISessionContext context;
        private Object lastInput = null;

        private AngleModifyListener() {
        }

        public void modifyText(TrackedModifyEvent e) {
            if (this.context == null) {
                return;
            }
            Spinner spinner = (Spinner)e.getWidget();
            final String textValue = spinner.getText();
            final Object input = this.lastInput;
            try {
                this.context.getSession().syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                        Resource domainAxis = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
                        try {
                            Double value = Double.parseDouble(textValue);
                            Double oldValue = (Double)graph.getPossibleRelatedValue(domainAxis, jfree.Axis_rotateLabelDegrees, (Binding)Bindings.DOUBLE);
                            if (oldValue == null || !oldValue.equals(value)) {
                                graph.claimLiteral(domainAxis, jfree.Axis_rotateLabelDegrees, (Object)value, (Binding)Bindings.DOUBLE);
                                BarAxisTab.this.angleInt = value.intValue();
                            }
                        }
                        catch (NumberFormatException e) {
                            graph.claimLiteral(domainAxis, jfree.Axis_rotateLabelDegrees, (Object)0.0, (Binding)Bindings.DOUBLE);
                            BarAxisTab.this.angleInt = 0;
                        }
                    }
                });
            }
            catch (DatabaseException e1) {
                e1.printStackTrace();
            }
        }

        public void setInput(ISessionContext context, Object parameter) {
            this.context = context;
            this.lastInput = parameter;
        }
    }

    private class AngleSelectionFactory
    extends ReadFactoryImpl<Resource, Integer> {
        private AngleSelectionFactory() {
        }

        public Integer perform(ReadGraph graph, Resource domainAxis) throws DatabaseException {
            if (BarAxisTab.this.angleInt == null) {
                Double value;
                Double angle = 0.0;
                JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                if (domainAxis != null && (value = (Double)graph.getPossibleRelatedValue(domainAxis, jfree.Axis_rotateLabelDegrees)) != null) {
                    angle = value;
                }
                return angle.intValue();
            }
            return BarAxisTab.this.angleInt;
        }
    }
}

