/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.workbench.internal.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.ModelBrowserPreferences;

/**
 * @author Antti Villberg <antti.villberg@semantum.fi>
 */
public class ModelBrowserPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

    public ModelBrowserPreferencePage() {
        super(GRID);
        IPreferenceStore pf = new ScopedPreferenceStore(InstanceScope.INSTANCE, ModelBrowserPreferences.P_NODE);
        setPreferenceStore( pf );
    }

    @Override
    protected void createFieldEditors() {
    	
    	String[][] namesAndValues = {
    			new String[] { "Shared Ontologies", ModelBrowserPreferences.ONTOLOGY_VISIBILITY_SHARED },
    			new String[] { "All Ontologies", ModelBrowserPreferences.ONTOLOGY_VISIBILITY_ALL }
    	};
    	
    	ComboFieldEditor ontologyVisibility = new ComboFieldEditor(ModelBrowserPreferences.P_ONTOLOGY_VISIBILITY, "Ontology Visibility", namesAndValues, getFieldEditorParent());
        addField(ontologyVisibility);

    }

	@Override
	public void init(IWorkbench workbench) {
	}

}
